% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTeamBowlingDetails.R
\name{getTeamBowlingDetails}
\alias{getTeamBowlingDetails}
\title{Get the team bowling details}
\usage{
getTeamBowlingDetails(team,dir=".",save=FALSE, odir=".")
}
\arguments{
\item{team}{The team for which detailed bowling info is required}

\item{dir}{The source directory of RData files obtained with  convertAllYaml2RDataframes()}

\item{save}{Whether the data frame needs to be saved as RData or not. It is recommended to set save=TRUE
as the data can be used for a lot of analyses of batsmen}

\item{odir}{The output directory}
}
\value{
bowlingDetails
The dataframe with the bowling details
}
\description{
This function  gets the bowling details of a team in all matchs against all
oppositions. This gets all the details of the bowlers for e.g deliveries, maidens, runs,
wickets, venue, date, winner ec
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
a <- getTeamBowlingDetails("India",dir="../data",save=TRUE,odir=".")
}

}
\references{
\url{https://cricsheet.org/}\cr
\url{https://gigadom.in/}\cr
\url{https://github.com/tvganesh/yorkrData/}
}
\seealso{
\code{\link{getBatsmanDetails}}\cr
\code{\link{getBowlerWicketDetails}}\cr
\code{\link{batsmanDismissals}}\cr
\code{\link{getTeamBattingDetails}}\cr
}
\author{
Tinniam V Ganesh
}
