% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ae.R
\name{aeCharacteristic}
\alias{aeCharacteristic}
\title{Asymptotic Expansion - Characteristic Function}
\usage{
aeCharacteristic(..., ae, eps = 1, order = NULL)
}
\arguments{
\item{...}{named argument, data.frame, list, or environment specifying the grid to evaluate the characteristic function. See examples.}

\item{ae}{an object of class \code{\link{yuima.ae-class}}.}

\item{eps}{numeric. The intensity of the perturbation.}

\item{order}{integer. The expansion order. If \code{NULL} (default), it uses the maximum order used in \code{ae}.}
}
\value{
Characteristic function evaluated on the given grid.
}
\description{
Asymptotic Expansion - Characteristic Function
}
\examples{
\dontrun{
# model
gbm <- setModel(drift = 'mu*x', diffusion = 'sigma*x', solve.variable = 'x')

# settings
xinit <- 100
par <- list(mu = 0.01, sigma = 0.2)
sampling <- setSampling(Initial = 0, Terminal = 1, n = 1000)

# asymptotic expansion
approx <- ae(model = gbm, sampling = sampling, order = 4, true.parameter = par, xinit = xinit)

# The following are all equivalent methods to specify the grid via ....
# Notice that the character 'u1' corresponds to the 'u.var' of the ae object.
approx@u.var

# 1) named argument  
u1 <- seq(0, 1, by = 0.1)
psi <- aeCharacteristic(u1 = u1, ae = approx, order = 4)
# 2) data frame
df <- data.frame(u1 = seq(0, 1, by = 0.1))
psi <- aeCharacteristic(df, ae = approx, order = 4)
# 3) environment
env <- new.env()
env$u1 <- seq(0, 1, by = 0.1)
psi <- aeCharacteristic(env, ae = approx, order = 4)
# 4) list
lst <- list(u1 = seq(0, 1, by = 0.1))
psi <- aeCharacteristic(lst, ae = approx, order = 4)
}
}
