% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json.R
\name{read_json_conn}
\alias{read_json_conn}
\title{Parse JSON from an R connection object.}
\usage{
read_json_conn(conn, opts = list(), ...)
}
\arguments{
\item{conn}{connection object.  e.g. \code{url('https://jsonplaceholder.typicode.com/todos/1')}}

\item{opts}{Named list of options for parsing. Usually created by \code{opts_read_json()}}

\item{...}{Other named options can be used to override any options in \code{opts}.
The valid named options are identical to arguments to \code{\link[=opts_read_json]{opts_read_json()}}}
}
\value{
R object
}
\description{
Currently, this is not very efficient as the entire contents of the connection are
read into R as a string and then the JSON parsed from there.
}
\details{
For plain text files it is faster to use
\code{read_json_file()}.
}
\examples{
if (interactive()) {
  read_json_conn(url("https://api.github.com/users/hadley/repos"))
}


}
\seealso{
Other JSON Parsers: 
\code{\link{read_json_file}()},
\code{\link{read_json_raw}()},
\code{\link{read_json_str}()}
}
\concept{JSON Parsers}
