% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tickets.R
\name{get_tickets}
\alias{get_tickets}
\title{Get Zendesk Tickets}
\usage{
get_tickets(email_id, token, subdomain, start_time, end_time)
}
\arguments{
\item{email_id}{Zendesk Email Id (username).}

\item{token}{Zendesk API token.}

\item{subdomain}{Your organization's Zendesk sub-domain.}

\item{start_time}{String with a date or datetime to get all
tickets modified after that date.}

\item{end_time}{String with a date or datetime to get all
tickets modified before that date.}
}
\value{
a Data Frame containing all tickets after the
start time.
}
\description{
This function takes your Email Id, authentication token,
sub-domain and start time as parameters and gets all the
tickets which have been updated on or after the start
time parameter. By default each page returns 1000 unique
tickets and an "after_cursor" value which stores a
pointer to the next page. After getting the first page
it uses the pointer to fetch the subsequent pages.
}
\details{
The start time parameter should be in 'UTC' format as
Zendesk uses the 'UTC' time zone when retrieving tickets
after the start time. For example, the US Eastern Time Zone
is currently four hours being UTC. If one wanted to get tickets
starting on August 1 at 12 am, you would need to enter
"2020-08-01 04:00:00". The user must do proper adjustment
to accommodate the time zone difference, if desired. A
date can be provided, it will retrieve results as of 12 am
in the UTC time zone.

Start and end times can be entered with or without the time
component. End time cannot be in the future, but should work
for values up to one minute prior to the current time.

It's not a good practice to write down these authentication
parameters in your code. There are various methods and
packages available that are more secure; this package
doesn't require you to use any one in particular.
}
\examples{
\dontrun{
all_tickets <- get_tickets(email_id, token, subdomain,
start_time = "2021-01-31 00:00:00", end_time = "2021-01-31 23:59:59")
}
}
\references{
\url{https://developer.zendesk.com/rest_api
/docs/support/incremental_export#start_time}
}
