% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zen4R_exporter.R
\name{export_zenodo}
\alias{export_zenodo}
\title{export_zenodo}
\usage{
export_zenodo(doi, filename, format, append_format = TRUE, logger = NULL)
}
\arguments{
\item{doi}{a Zenodo DOI or concept DOI}

\item{filename}{a base file name (without file extension) to export to.}

\item{format}{a valid Zenodo export format among the following: BibTeX, CSL, DataCite, DublinCore, 
DCAT, JSON, JSON-LD, GeoJSON, MARCXML.}

\item{append_format}{wether format name has to be appended to the filename. Default is \code{TRUE} (for
backward compatibility reasons). Set it to \code{FALSE} if you want to use only the \code{filename}.}

\item{logger}{a logger to print Zenodo API-related messages. The logger can be either NULL, 
"INFO" (with minimum logs), or "DEBUG" (for complete curl http calls logs)}
}
\value{
the exported file name (with extension)
}
\description{
\code{export_zenodo} allows to export a Zenodo record, identified by its 
DOI or concept DOI, using one of the export formats supported by Zenodo.
}
\examples{
\dontrun{
 export_zenodo("10.5281/zenodo.2547036", filename = "test", format = "BibTeX", append_format = F)
}
                
}
