% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZenodoRecord.R
\docType{class}
\name{ZenodoRecord}
\alias{ZenodoRecord}
\title{ZenodoRecord}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ZenodoRecord
}
\description{
ZenodoRecord

ZenodoRecord
}
\note{
See examples in \code{\link{download_zenodo}} utility function.
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{record}
\keyword{zenodo}
\section{Super class}{
\code{\link[zen4R:zen4RLogger]{zen4R::zen4RLogger}} -> \code{ZenodoRecord}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{conceptdoi}}{record Concept DOI (common to all record versions)}

\item{\code{conceptrecid}}{record concept id}

\item{\code{created}}{record creation date}

\item{\code{doi}}{record doi}

\item{\code{doi_url}}{record doi URL}

\item{\code{files}}{list of files associated to the record}

\item{\code{id}}{record id}

\item{\code{links}}{list of links associated to the record}

\item{\code{metadata}}{metadata elements associated to the record}

\item{\code{modified}}{record modification date}

\item{\code{owner}}{record owner}

\item{\code{record_id}}{record_id}

\item{\code{state}}{record state}

\item{\code{submitted}}{record submission status}

\item{\code{title}}{record title}

\item{\code{version}}{record version}

\item{\code{stats}}{stats}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ZenodoRecord-new}{\code{ZenodoRecord$new()}}
\item \href{#method-ZenodoRecord-prereserveDOI}{\code{ZenodoRecord$prereserveDOI()}}
\item \href{#method-ZenodoRecord-setDOI}{\code{ZenodoRecord$setDOI()}}
\item \href{#method-ZenodoRecord-getConceptDOI}{\code{ZenodoRecord$getConceptDOI()}}
\item \href{#method-ZenodoRecord-getFirstDOI}{\code{ZenodoRecord$getFirstDOI()}}
\item \href{#method-ZenodoRecord-getLastDOI}{\code{ZenodoRecord$getLastDOI()}}
\item \href{#method-ZenodoRecord-getVersions}{\code{ZenodoRecord$getVersions()}}
\item \href{#method-ZenodoRecord-getStats}{\code{ZenodoRecord$getStats()}}
\item \href{#method-ZenodoRecord-setUploadType}{\code{ZenodoRecord$setUploadType()}}
\item \href{#method-ZenodoRecord-setPublicationType}{\code{ZenodoRecord$setPublicationType()}}
\item \href{#method-ZenodoRecord-setImageType}{\code{ZenodoRecord$setImageType()}}
\item \href{#method-ZenodoRecord-setPublicationDate}{\code{ZenodoRecord$setPublicationDate()}}
\item \href{#method-ZenodoRecord-setEmbargoDate}{\code{ZenodoRecord$setEmbargoDate()}}
\item \href{#method-ZenodoRecord-setTitle}{\code{ZenodoRecord$setTitle()}}
\item \href{#method-ZenodoRecord-setDescription}{\code{ZenodoRecord$setDescription()}}
\item \href{#method-ZenodoRecord-setAccessRight}{\code{ZenodoRecord$setAccessRight()}}
\item \href{#method-ZenodoRecord-setAccessConditions}{\code{ZenodoRecord$setAccessConditions()}}
\item \href{#method-ZenodoRecord-addCreator}{\code{ZenodoRecord$addCreator()}}
\item \href{#method-ZenodoRecord-removeCreator}{\code{ZenodoRecord$removeCreator()}}
\item \href{#method-ZenodoRecord-removeCreatorByName}{\code{ZenodoRecord$removeCreatorByName()}}
\item \href{#method-ZenodoRecord-removeCreatorByAffiliation}{\code{ZenodoRecord$removeCreatorByAffiliation()}}
\item \href{#method-ZenodoRecord-removeCreatorByORCID}{\code{ZenodoRecord$removeCreatorByORCID()}}
\item \href{#method-ZenodoRecord-removeCreatorByGND}{\code{ZenodoRecord$removeCreatorByGND()}}
\item \href{#method-ZenodoRecord-addContributor}{\code{ZenodoRecord$addContributor()}}
\item \href{#method-ZenodoRecord-removeContributor}{\code{ZenodoRecord$removeContributor()}}
\item \href{#method-ZenodoRecord-removeContributorByName}{\code{ZenodoRecord$removeContributorByName()}}
\item \href{#method-ZenodoRecord-removeContributorByAffiliation}{\code{ZenodoRecord$removeContributorByAffiliation()}}
\item \href{#method-ZenodoRecord-removeContributorByORCID}{\code{ZenodoRecord$removeContributorByORCID()}}
\item \href{#method-ZenodoRecord-removeContributorByGND}{\code{ZenodoRecord$removeContributorByGND()}}
\item \href{#method-ZenodoRecord-setLicense}{\code{ZenodoRecord$setLicense()}}
\item \href{#method-ZenodoRecord-setVersion}{\code{ZenodoRecord$setVersion()}}
\item \href{#method-ZenodoRecord-setLanguage}{\code{ZenodoRecord$setLanguage()}}
\item \href{#method-ZenodoRecord-addRelatedIdentifier}{\code{ZenodoRecord$addRelatedIdentifier()}}
\item \href{#method-ZenodoRecord-removeRelatedIdentifier}{\code{ZenodoRecord$removeRelatedIdentifier()}}
\item \href{#method-ZenodoRecord-setReferences}{\code{ZenodoRecord$setReferences()}}
\item \href{#method-ZenodoRecord-addReference}{\code{ZenodoRecord$addReference()}}
\item \href{#method-ZenodoRecord-removeReference}{\code{ZenodoRecord$removeReference()}}
\item \href{#method-ZenodoRecord-setKeywords}{\code{ZenodoRecord$setKeywords()}}
\item \href{#method-ZenodoRecord-addKeyword}{\code{ZenodoRecord$addKeyword()}}
\item \href{#method-ZenodoRecord-removeKeyword}{\code{ZenodoRecord$removeKeyword()}}
\item \href{#method-ZenodoRecord-addSubject}{\code{ZenodoRecord$addSubject()}}
\item \href{#method-ZenodoRecord-removeSubject}{\code{ZenodoRecord$removeSubject()}}
\item \href{#method-ZenodoRecord-removeSubjectByTerm}{\code{ZenodoRecord$removeSubjectByTerm()}}
\item \href{#method-ZenodoRecord-removeSubjectByIdentifier}{\code{ZenodoRecord$removeSubjectByIdentifier()}}
\item \href{#method-ZenodoRecord-setNotes}{\code{ZenodoRecord$setNotes()}}
\item \href{#method-ZenodoRecord-setCommunities}{\code{ZenodoRecord$setCommunities()}}
\item \href{#method-ZenodoRecord-addCommunity}{\code{ZenodoRecord$addCommunity()}}
\item \href{#method-ZenodoRecord-removeCommunity}{\code{ZenodoRecord$removeCommunity()}}
\item \href{#method-ZenodoRecord-setGrants}{\code{ZenodoRecord$setGrants()}}
\item \href{#method-ZenodoRecord-addGrant}{\code{ZenodoRecord$addGrant()}}
\item \href{#method-ZenodoRecord-removeGrant}{\code{ZenodoRecord$removeGrant()}}
\item \href{#method-ZenodoRecord-setJournalTitle}{\code{ZenodoRecord$setJournalTitle()}}
\item \href{#method-ZenodoRecord-setJournalVolume}{\code{ZenodoRecord$setJournalVolume()}}
\item \href{#method-ZenodoRecord-setJournalIssue}{\code{ZenodoRecord$setJournalIssue()}}
\item \href{#method-ZenodoRecord-setJournalPages}{\code{ZenodoRecord$setJournalPages()}}
\item \href{#method-ZenodoRecord-setConferenceTitle}{\code{ZenodoRecord$setConferenceTitle()}}
\item \href{#method-ZenodoRecord-setConferenceAcronym}{\code{ZenodoRecord$setConferenceAcronym()}}
\item \href{#method-ZenodoRecord-setConferenceDates}{\code{ZenodoRecord$setConferenceDates()}}
\item \href{#method-ZenodoRecord-setConferencePlace}{\code{ZenodoRecord$setConferencePlace()}}
\item \href{#method-ZenodoRecord-setConferenceUrl}{\code{ZenodoRecord$setConferenceUrl()}}
\item \href{#method-ZenodoRecord-setConferenceSession}{\code{ZenodoRecord$setConferenceSession()}}
\item \href{#method-ZenodoRecord-setConferenceSessionPart}{\code{ZenodoRecord$setConferenceSessionPart()}}
\item \href{#method-ZenodoRecord-setImprintPublisher}{\code{ZenodoRecord$setImprintPublisher()}}
\item \href{#method-ZenodoRecord-setImprintISBN}{\code{ZenodoRecord$setImprintISBN()}}
\item \href{#method-ZenodoRecord-setImprintPlace}{\code{ZenodoRecord$setImprintPlace()}}
\item \href{#method-ZenodoRecord-setPartofTitle}{\code{ZenodoRecord$setPartofTitle()}}
\item \href{#method-ZenodoRecord-setPartofPages}{\code{ZenodoRecord$setPartofPages()}}
\item \href{#method-ZenodoRecord-setThesisUniversity}{\code{ZenodoRecord$setThesisUniversity()}}
\item \href{#method-ZenodoRecord-addThesisSupervisor}{\code{ZenodoRecord$addThesisSupervisor()}}
\item \href{#method-ZenodoRecord-removeThesisSupervisor}{\code{ZenodoRecord$removeThesisSupervisor()}}
\item \href{#method-ZenodoRecord-removeThesisSupervisorByName}{\code{ZenodoRecord$removeThesisSupervisorByName()}}
\item \href{#method-ZenodoRecord-removeThesisSupervisorByAffiliation}{\code{ZenodoRecord$removeThesisSupervisorByAffiliation()}}
\item \href{#method-ZenodoRecord-removeThesisSupervisorByORCID}{\code{ZenodoRecord$removeThesisSupervisorByORCID()}}
\item \href{#method-ZenodoRecord-removeThesisSupervisorByGND}{\code{ZenodoRecord$removeThesisSupervisorByGND()}}
\item \href{#method-ZenodoRecord-addLocation}{\code{ZenodoRecord$addLocation()}}
\item \href{#method-ZenodoRecord-removeLocation}{\code{ZenodoRecord$removeLocation()}}
\item \href{#method-ZenodoRecord-exportAs}{\code{ZenodoRecord$exportAs()}}
\item \href{#method-ZenodoRecord-exportAsBibTeX}{\code{ZenodoRecord$exportAsBibTeX()}}
\item \href{#method-ZenodoRecord-exportAsCSL}{\code{ZenodoRecord$exportAsCSL()}}
\item \href{#method-ZenodoRecord-exportAsDataCite}{\code{ZenodoRecord$exportAsDataCite()}}
\item \href{#method-ZenodoRecord-exportAsDublinCore}{\code{ZenodoRecord$exportAsDublinCore()}}
\item \href{#method-ZenodoRecord-exportAsDCAT}{\code{ZenodoRecord$exportAsDCAT()}}
\item \href{#method-ZenodoRecord-exportAsJSON}{\code{ZenodoRecord$exportAsJSON()}}
\item \href{#method-ZenodoRecord-exportAsJSONLD}{\code{ZenodoRecord$exportAsJSONLD()}}
\item \href{#method-ZenodoRecord-exportAsGeoJSON}{\code{ZenodoRecord$exportAsGeoJSON()}}
\item \href{#method-ZenodoRecord-exportAsMARCXML}{\code{ZenodoRecord$exportAsMARCXML()}}
\item \href{#method-ZenodoRecord-exportAsAllFormats}{\code{ZenodoRecord$exportAsAllFormats()}}
\item \href{#method-ZenodoRecord-listFiles}{\code{ZenodoRecord$listFiles()}}
\item \href{#method-ZenodoRecord-downloadFiles}{\code{ZenodoRecord$downloadFiles()}}
\item \href{#method-ZenodoRecord-print}{\code{ZenodoRecord$print()}}
\item \href{#method-ZenodoRecord-toDCEntry}{\code{ZenodoRecord$toDCEntry()}}
\item \href{#method-ZenodoRecord-clone}{\code{ZenodoRecord$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="zen4R" data-topic="zen4RLogger" data-id="ERROR"><a href='../../zen4R/html/zen4RLogger.html#method-zen4RLogger-ERROR'><code>zen4R::zen4RLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="zen4R" data-topic="zen4RLogger" data-id="INFO"><a href='../../zen4R/html/zen4RLogger.html#method-zen4RLogger-INFO'><code>zen4R::zen4RLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="zen4R" data-topic="zen4RLogger" data-id="WARN"><a href='../../zen4R/html/zen4RLogger.html#method-zen4RLogger-WARN'><code>zen4R::zen4RLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="zen4R" data-topic="zen4RLogger" data-id="getClass"><a href='../../zen4R/html/zen4RLogger.html#method-zen4RLogger-getClass'><code>zen4R::zen4RLogger$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="zen4R" data-topic="zen4RLogger" data-id="getClassName"><a href='../../zen4R/html/zen4RLogger.html#method-zen4RLogger-getClassName'><code>zen4R::zen4RLogger$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="zen4R" data-topic="zen4RLogger" data-id="logger"><a href='../../zen4R/html/zen4RLogger.html#method-zen4RLogger-logger'><code>zen4R::zen4RLogger$logger()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-new"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-new}{}}}
\subsection{Method \code{new()}}{
method is used to instantiate a \code{\link{ZenodoRecord}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$new(obj = NULL, logger = "INFO")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{obj}}{an optional list object to create the record}

\item{\code{logger}}{a logger to print log messages. It can be either NULL, "INFO" (with minimum logs), 
or "DEBUG" (for complete curl http calls logs)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-prereserveDOI"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-prereserveDOI}{}}}
\subsection{Method \code{prereserveDOI()}}{
Set prereserve_doi if \code{TRUE}, \code{FALSE} otherwise to create a record without
   prereserved DOI by Zenodo. By default, this method will be called to prereserve a DOI assuming 
   the record created doesn't yet handle a DOI. To avoid prereserving a DOI call \code{$prereserveDOI(FALSE)} 
   on your record.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$prereserveDOI(prereserve)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prereserve}}{whether a DOI has to be pre-reserved by Zenodo}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setDOI"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setDOI}{}}}
\subsection{Method \code{setDOI()}}{
Set the DOI. This method can be used if a DOI has been already assigned outside Zenodo.
   This method will call the method \code{$prereserveDOI(FALSE)}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setDOI(doi)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{doi}}{DOI to set for the record}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-getConceptDOI"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-getConceptDOI}{}}}
\subsection{Method \code{getConceptDOI()}}{
Get the concept (generic) DOI. The concept DOI is a generic DOI common to all versions
   of a Zenodo record. When a deposit is unsubmitted, this concept DOI is inherited based
   on the prereserved DOI of the first record version.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$getConceptDOI()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the concept DOI, object of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-getFirstDOI"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-getFirstDOI}{}}}
\subsection{Method \code{getFirstDOI()}}{
Get DOI of the first record version.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$getFirstDOI()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the first DOI, object of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-getLastDOI"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-getLastDOI}{}}}
\subsection{Method \code{getLastDOI()}}{
Get DOI of the latest record version.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$getLastDOI()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the last DOI, object of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-getVersions"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-getVersions}{}}}
\subsection{Method \code{getVersions()}}{
Get record versions with creation/publication date, 
  version (ordering number) and DOI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$getVersions()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a \code{data.frame} with the record versions
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-getStats"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-getStats}{}}}
\subsection{Method \code{getStats()}}{
Get record statistics
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$getStats()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
statistics as \code{data.frame}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setUploadType"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setUploadType}{}}}
\subsection{Method \code{setUploadType()}}{
Set the upload type (mandatory).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setUploadType(uploadType)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uploadType}}{record upload type among the following values: 'publication', 'poster', 
'presentation', 'dataset', 'image', 'video', 'software', 'lesson', 'physicalobject', 'other'}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setPublicationType"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setPublicationType}{}}}
\subsection{Method \code{setPublicationType()}}{
Set the publication type (mandatory if upload type is 'publication').
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setPublicationType(publicationType)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{publicationType}}{record publication type among the following values: 'annotationcollection', 'book', 
'section', 'conferencepaper', 'datamanagementplan', 'article', 'patent', 'preprint', 'deliverable', 'milestone', 
'proposal', 'report', 'softwaredocumentation', 'taxonomictreatment', 'technicalnote', 'thesis', 'workingpaper', 
'other'}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setImageType"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setImageType}{}}}
\subsection{Method \code{setImageType()}}{
Set the image type (mandatory if image type is 'image').
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setImageType(imageType)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{imageType}}{record publication type among the following values: 'figure','plot',
'drawing','diagram','photo', or 'other'}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setPublicationDate"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setPublicationDate}{}}}
\subsection{Method \code{setPublicationDate()}}{
Set the publication date.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setPublicationDate(publicationDate)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{publicationDate}}{object of class \code{Date}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setEmbargoDate"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setEmbargoDate}{}}}
\subsection{Method \code{setEmbargoDate()}}{
Set the embargo date.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setEmbargoDate(embargoDate)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{embargoDate}}{object of class \code{Date}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setTitle"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setTitle}{}}}
\subsection{Method \code{setTitle()}}{
Set the record title.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setTitle(title)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{title}}{object of class \code{character}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setDescription"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setDescription}{}}}
\subsection{Method \code{setDescription()}}{
Set the record description
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setDescription(description)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{description}}{object of class \code{character}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setAccessRight"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setAccessRight}{}}}
\subsection{Method \code{setAccessRight()}}{
Set the access right.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setAccessRight(accessRight)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{accessRight}}{record access right among the following values: 'open','embargoed', 'restricted','closed'}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setAccessConditions"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setAccessConditions}{}}}
\subsection{Method \code{setAccessConditions()}}{
set the access conditions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setAccessConditions(accessConditions)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{accessConditions}}{object of class \code{character}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-addCreator"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-addCreator}{}}}
\subsection{Method \code{addCreator()}}{
Add a creator for the record. One approach is to use the \code{firstname} and
   \code{lastname} arguments, that by default will be concatenated for Zenodo as
   \code{lastname, firstname}. For more flexibility over this, the \code{name}
   argument can be directly used.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$addCreator(
  firstname,
  lastname,
  name = paste(lastname, firstname, sep = ", "),
  affiliation = NULL,
  orcid = NULL,
  gnd = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{firstname}}{creator first name}

\item{\code{lastname}}{creator last name}

\item{\code{name}}{creator name}

\item{\code{affiliation}}{creator affiliation (optional)}

\item{\code{orcid}}{creator ORCID (optional)}

\item{\code{gnd}}{creator GND (optional)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-removeCreator"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-removeCreator}{}}}
\subsection{Method \code{removeCreator()}}{
Removes a creator by a property. The \code{by} parameter should be the name
   of the creator property ('name' - in the form 'lastname, firstname', 'affiliation',
   'orcid' or 'gnd').
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$removeCreator(by, property)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{by}}{property used as criterion to remove the creator}

\item{\code{property}}{property value used to remove the creator}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if removed, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-removeCreatorByName"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-removeCreatorByName}{}}}
\subsection{Method \code{removeCreatorByName()}}{
Removes a creator by name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$removeCreatorByName(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{creator name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if removed, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-removeCreatorByAffiliation"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-removeCreatorByAffiliation}{}}}
\subsection{Method \code{removeCreatorByAffiliation()}}{
Removes a creator by affiliation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$removeCreatorByAffiliation(affiliation)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{affiliation}}{creator affiliation}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if removed, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-removeCreatorByORCID"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-removeCreatorByORCID}{}}}
\subsection{Method \code{removeCreatorByORCID()}}{
Removes a creator by ORCID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$removeCreatorByORCID(orcid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{orcid}}{creator ORCID}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if removed, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-removeCreatorByGND"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-removeCreatorByGND}{}}}
\subsection{Method \code{removeCreatorByGND()}}{
Removes a creator by GND.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$removeCreatorByGND(gnd)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{gnd}}{creator GND}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if removed, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-addContributor"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-addContributor}{}}}
\subsection{Method \code{addContributor()}}{
Add a contributor for the record. One approach is to use the \code{firstname} and
   \code{lastname} arguments, that by default will be concatenated for Zenodo as
   \code{lastname, firstname}. For more flexibility over this, the \code{name}
   argument can be directly used.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$addContributor(
  firstname,
  lastname,
  name = paste(lastname, firstname, sep = ", "),
  type,
  affiliation = NULL,
  orcid = NULL,
  gnd = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{firstname}}{contributor first name}

\item{\code{lastname}}{contributor last name}

\item{\code{name}}{contributor name}

\item{\code{type}}{contributor type, among values: ContactPerson, 
DataCollector, DataCurator, DataManager, Distributor, Editor, Funder, HostingInstitution, 
Producer, ProjectLeader, ProjectManager, ProjectMember, RegistrationAgency, RegistrationAuthority,
RelatedPerson, Researcher, ResearchGroup, RightsHolder, Supervisor, Sponsor, WorkPackageLeader, Other.}

\item{\code{affiliation}}{contributor affiliation (optional)}

\item{\code{orcid}}{contributor orcid (optional)}

\item{\code{gnd}}{contributor gnd (optional)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-removeContributor"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-removeContributor}{}}}
\subsection{Method \code{removeContributor()}}{
Removes a contributor by a property. The \code{by} parameter should be the name
   of the contributor property ('name' - in the form 'lastname, firstname', 'affiliation',
   'orcid' or 'gnd').
   \code{FALSE} otherwise.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$removeContributor(by, property)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{by}}{property used as criterion to remove the contributor}

\item{\code{property}}{property value used to remove the contributor}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if removed, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-removeContributorByName"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-removeContributorByName}{}}}
\subsection{Method \code{removeContributorByName()}}{
Removes a contributor by name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$removeContributorByName(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{contributor name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if removed, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-removeContributorByAffiliation"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-removeContributorByAffiliation}{}}}
\subsection{Method \code{removeContributorByAffiliation()}}{
Removes a contributor by affiliation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$removeContributorByAffiliation(affiliation)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{affiliation}}{contributor affiliation}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if removed, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-removeContributorByORCID"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-removeContributorByORCID}{}}}
\subsection{Method \code{removeContributorByORCID()}}{
Removes a contributor by ORCID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$removeContributorByORCID(orcid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{orcid}}{contributor ORCID}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if removed, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-removeContributorByGND"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-removeContributorByGND}{}}}
\subsection{Method \code{removeContributorByGND()}}{
Removes a contributor by GND.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$removeContributorByGND(gnd)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{gnd}}{contributor GND}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if removed, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setLicense"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setLicense}{}}}
\subsection{Method \code{setLicense()}}{
Set license. The license should be set with the Zenodo id of the license. If not
   recognized by Zenodo, the function will return an error. The list of licenses can
   fetched with the \code{ZenodoManager} and the function \code{$getLicenses()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setLicense(licenseId, sandbox = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{licenseId}}{a license Id}

\item{\code{sandbox}}{Use the Zenodo sandbox infrastructure as basis to control available licenses. Default is \code{FALSE}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setVersion"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setVersion}{}}}
\subsection{Method \code{setVersion()}}{
Set record version.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setVersion(version)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{version}}{the record version to set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setLanguage"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setLanguage}{}}}
\subsection{Method \code{setLanguage()}}{
Set the language.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setLanguage(language)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{language}}{ISO 639-2 or 639-3 code}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-addRelatedIdentifier"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-addRelatedIdentifier}{}}}
\subsection{Method \code{addRelatedIdentifier()}}{
Adds a related identifier with a given relation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$addRelatedIdentifier(relation, identifier, resource_type = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{relation}}{relation type among following values: isCitedBy, cites, isSupplementTo, isSupplementedBy, 
isContinuedBy, continues, isDescribedBy, describes, hasMetadata, isMetadataFor, isNewVersionOf, 
isPreviousVersionOf, isPartOf, hasPart, isReferencedBy, references, isDocumentedBy, documents, 
isCompiledBy, compiles, isVariantFormOf, isOriginalFormof, isIdenticalTo, isAlternateIdentifier, 
isReviewedBy, reviews, isDerivedFrom, isSourceOf, requires, isRequiredBy, isObsoletedBy, obsoletes}

\item{\code{identifier}}{resource identifier}

\item{\code{resource_type}}{optional resource type, value among possible publication types, image types, or upload 
types (except 'publication' and 'image' for which a publication/image has to be specified). Default is \code{NULL}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-removeRelatedIdentifier"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-removeRelatedIdentifier}{}}}
\subsection{Method \code{removeRelatedIdentifier()}}{
Removes a related identifier with a given relation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$removeRelatedIdentifier(relation, identifier)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{relation}}{relation type among following values: isCitedBy, cites, isSupplementTo, isSupplementedBy, 
isContinuedBy, continues, isDescribedBy, describes, hasMetadata, isMetadataFor, isNewVersionOf, 
isPreviousVersionOf, isPartOf, hasPart, isReferencedBy, references, isDocumentedBy, documents, 
isCompiledBy, compiles, isVariantFormOf, isOriginalFormof, isIdenticalTo, isAlternateIdentifier, 
isReviewedBy, reviews, isDerivedFrom, isSourceOf, requires, isRequiredBy, isObsoletedBy, obsoletes}

\item{\code{identifier}}{resource identifier}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setReferences"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setReferences}{}}}
\subsection{Method \code{setReferences()}}{
Set references
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setReferences(references)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{references}}{a vector or list of references to set for the record}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-addReference"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-addReference}{}}}
\subsection{Method \code{addReference()}}{
Add a reference
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$addReference(reference)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{reference}}{the reference to add}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-removeReference"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-removeReference}{}}}
\subsection{Method \code{removeReference()}}{
Remove a reference
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$removeReference(reference)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{reference}}{the reference to remove}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if removed, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setKeywords"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setKeywords}{}}}
\subsection{Method \code{setKeywords()}}{
Set keywords
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setKeywords(keywords)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keywords}}{a vector or list of keywords to set for the record}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-addKeyword"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-addKeyword}{}}}
\subsection{Method \code{addKeyword()}}{
Add a keyword
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$addKeyword(keyword)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keyword}}{the keyword to add}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-removeKeyword"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-removeKeyword}{}}}
\subsection{Method \code{removeKeyword()}}{
Remove a keyword
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$removeKeyword(keyword)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keyword}}{the keyword to remove}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if removed, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-addSubject"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-addSubject}{}}}
\subsection{Method \code{addSubject()}}{
Adds a subject given a term and identifier
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$addSubject(term, identifier)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{term}}{subject term}

\item{\code{identifier}}{subject identifier}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-removeSubject"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-removeSubject}{}}}
\subsection{Method \code{removeSubject()}}{
Removes subject(s) by a property. The \code{by} parameter should be the name
   of the subject property ('term' or 'identifier').
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$removeSubject(by, property)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{by}}{property used as criterion to remove subjects}

\item{\code{property}}{property value used to remove subjects}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if at least one subject is removed, \code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-removeSubjectByTerm"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-removeSubjectByTerm}{}}}
\subsection{Method \code{removeSubjectByTerm()}}{
Removes subject(s) by term.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$removeSubjectByTerm(term)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{term}}{the term to use to remove subject(s)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if at least one subject is removed, \code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-removeSubjectByIdentifier"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-removeSubjectByIdentifier}{}}}
\subsection{Method \code{removeSubjectByIdentifier()}}{
Removes subject(s) by identifier
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$removeSubjectByIdentifier(identifier)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{identifier}}{the identifier to use to remove subject(s)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if at least one subject is removed, \code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setNotes"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setNotes}{}}}
\subsection{Method \code{setNotes()}}{
Set notes. HTML is not allowed
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setNotes(notes)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{notes}}{object of class \code{character}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setCommunities"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setCommunities}{}}}
\subsection{Method \code{setCommunities()}}{
Set a vector of character strings identifying communities
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setCommunities(communities, sandbox = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{communities}}{a vector or list of communities. Values should among known communities. The list of communities can
fetched with the \code{ZenodoManager} and the function \code{$getCommunities()}. Each community should be set with 
the Zenodo id of the community. If not recognized by Zenodo, the function will return an error.}

\item{\code{sandbox}}{Use the Zenodo sandbox infrastructure as basis to control available communities. Default is \code{FALSE}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-addCommunity"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-addCommunity}{}}}
\subsection{Method \code{addCommunity()}}{
Adds a community to the record metadata.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$addCommunity(community, sandbox = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{community}}{community to add. The community should be set with the Zenodo id of the community. 
If not recognized by Zenodo, the function will return an error. The list of communities can fetched 
with the \code{ZenodoManager} and the function \code{$getCommunities()}.}

\item{\code{sandbox}}{Use the Zenodo sandbox infrastructure as basis to control available communities. Default is \code{FALSE}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-removeCommunity"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-removeCommunity}{}}}
\subsection{Method \code{removeCommunity()}}{
Removes a community from the record metadata.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$removeCommunity(community)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{community}}{community to remove. The community should be set with the Zenodo id of the community.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if removed, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setGrants"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setGrants}{}}}
\subsection{Method \code{setGrants()}}{
Set a vector of character strings identifying grants
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setGrants(grants, sandbox = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{grants}}{a vector or list of grants Values should among known grants The list of grants can
fetched with the \code{ZenodoManager} and the function \code{$getGrants()}. Each grant should be set with 
the Zenodo id of the grant If not recognized by Zenodo, the function will raise a warning only.}

\item{\code{sandbox}}{Use the Zenodo sandbox infrastructure as basis to control available grants. Default is \code{FALSE}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-addGrant"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-addGrant}{}}}
\subsection{Method \code{addGrant()}}{
Adds a grant to the record metadata.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$addGrant(grant, sandbox = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{grant}}{grant to add. The grant should be set with the id of the grant. If not
recognized by Zenodo, the function will return an warning only. The list of grants can
fetched with the \code{ZenodoManager} and the function \code{$getGrants()}.}

\item{\code{sandbox}}{Use the Zenodo sandbox infrastructure as basis to control available grants. Default is \code{FALSE}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-removeGrant"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-removeGrant}{}}}
\subsection{Method \code{removeGrant()}}{
Removes a grant from the record metadata.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$removeGrant(grant)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{grant}}{grant to remove. The grant should be set with the Zenodo id of the grant}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if removed, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setJournalTitle"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setJournalTitle}{}}}
\subsection{Method \code{setJournalTitle()}}{
Set Journal title to the record metadata
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setJournalTitle(title)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{title}}{a title, object of class \code{character}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setJournalVolume"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setJournalVolume}{}}}
\subsection{Method \code{setJournalVolume()}}{
Set Journal volume to the record metadata
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setJournalVolume(volume)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{volume}}{a volume}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setJournalIssue"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setJournalIssue}{}}}
\subsection{Method \code{setJournalIssue()}}{
Set Journal issue to the record metadata
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setJournalIssue(issue)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{issue}}{an issue}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setJournalPages"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setJournalPages}{}}}
\subsection{Method \code{setJournalPages()}}{
Set Journal pages to the record metadata
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setJournalPages(pages)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pages}}{number of pages}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setConferenceTitle"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setConferenceTitle}{}}}
\subsection{Method \code{setConferenceTitle()}}{
Set conference title to the record metadata
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setConferenceTitle(title)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{title}}{conference title, object of class \code{character}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setConferenceAcronym"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setConferenceAcronym}{}}}
\subsection{Method \code{setConferenceAcronym()}}{
Set conference acronym to the record metadata
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setConferenceAcronym(acronym)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{acronym}}{conference acronym, object of class \code{character}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setConferenceDates"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setConferenceDates}{}}}
\subsection{Method \code{setConferenceDates()}}{
Set conference dates to the record metadata
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setConferenceDates(dates)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dates}}{conference dates, object of class \code{character}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setConferencePlace"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setConferencePlace}{}}}
\subsection{Method \code{setConferencePlace()}}{
Set conference place to the record metadata
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setConferencePlace(place)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{place}}{conference place, object of class \code{character}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setConferenceUrl"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setConferenceUrl}{}}}
\subsection{Method \code{setConferenceUrl()}}{
Set conference url to the record metadata
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setConferenceUrl(url)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{conference url, object of class \code{character}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setConferenceSession"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setConferenceSession}{}}}
\subsection{Method \code{setConferenceSession()}}{
Set conference session to the record metadata
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setConferenceSession(session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{session}}{conference session, object of class \code{character}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setConferenceSessionPart"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setConferenceSessionPart}{}}}
\subsection{Method \code{setConferenceSessionPart()}}{
Set conference session part to the record metadata
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setConferenceSessionPart(part)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{part}}{conference session part, object of class \code{character}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setImprintPublisher"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setImprintPublisher}{}}}
\subsection{Method \code{setImprintPublisher()}}{
Set imprint publisher to the record metadata
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setImprintPublisher(publisher)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{publisher}}{the publisher, object of class \code{character}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setImprintISBN"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setImprintISBN}{}}}
\subsection{Method \code{setImprintISBN()}}{
Set imprint ISBN to the record metadata
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setImprintISBN(isbn)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{isbn}}{the ISBN, object of class \code{character}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setImprintPlace"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setImprintPlace}{}}}
\subsection{Method \code{setImprintPlace()}}{
Set imprint place to the record metadata
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setImprintPlace(place)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{place}}{the place, object of class \code{character}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setPartofTitle"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setPartofTitle}{}}}
\subsection{Method \code{setPartofTitle()}}{
Set title to which record is part of
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setPartofTitle(title)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{title}}{the title, object of class \code{character}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setPartofPages"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setPartofPages}{}}}
\subsection{Method \code{setPartofPages()}}{
Set pages to which record is part of
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setPartofPages(pages)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pages}}{the pages, object of class \code{character}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-setThesisUniversity"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-setThesisUniversity}{}}}
\subsection{Method \code{setThesisUniversity()}}{
Set thesis university
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$setThesisUniversity(university)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{university}}{the university, object of class \code{character}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-addThesisSupervisor"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-addThesisSupervisor}{}}}
\subsection{Method \code{addThesisSupervisor()}}{
Adds thesis supervisor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$addThesisSupervisor(
  firstname,
  lastname,
  affiliation = NULL,
  orcid = NULL,
  gnd = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{firstname}}{supervisor first name}

\item{\code{lastname}}{supervisor last name}

\item{\code{affiliation}}{supervisor affiliation (optional)}

\item{\code{orcid}}{supervisor ORCID (optional)}

\item{\code{gnd}}{supervisor GND (optional)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-removeThesisSupervisor"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-removeThesisSupervisor}{}}}
\subsection{Method \code{removeThesisSupervisor()}}{
Removes a thesis supervisor by a property. The \code{by} parameter should be the name
   of the thesis supervisor property ('name' - in the form 'lastname, firstname', 'affiliation',
   'orcid' or 'gnd').
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$removeThesisSupervisor(by, property)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{by}}{property used as criterion to remove the thesis supervisor}

\item{\code{property}}{property value used to remove the thesis supervisor}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if removed, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-removeThesisSupervisorByName"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-removeThesisSupervisorByName}{}}}
\subsection{Method \code{removeThesisSupervisorByName()}}{
Removes a thesis supervisor by name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$removeThesisSupervisorByName(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{thesis supervisor name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if removed, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-removeThesisSupervisorByAffiliation"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-removeThesisSupervisorByAffiliation}{}}}
\subsection{Method \code{removeThesisSupervisorByAffiliation()}}{
Removes a thesis supervisor by affiliation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$removeThesisSupervisorByAffiliation(affiliation)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{affiliation}}{thesis supervisor affiliation}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if removed, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-removeThesisSupervisorByORCID"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-removeThesisSupervisorByORCID}{}}}
\subsection{Method \code{removeThesisSupervisorByORCID()}}{
Removes a thesis supervisor by ORCID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$removeThesisSupervisorByORCID(orcid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{orcid}}{thesis supervisor ORCID}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if removed, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-removeThesisSupervisorByGND"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-removeThesisSupervisorByGND}{}}}
\subsection{Method \code{removeThesisSupervisorByGND()}}{
Removes a thesis supervisor by GND
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$removeThesisSupervisorByGND(gnd)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{gnd}}{thesis supervisor GND}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if removed, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-addLocation"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-addLocation}{}}}
\subsection{Method \code{addLocation()}}{
Adds a location to the record metadata.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$addLocation(place, description = NULL, lat = NULL, lon = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{place}}{place (required)}

\item{\code{description}}{description}

\item{\code{lat}}{latitude}

\item{\code{lon}}{longitude}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-removeLocation"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-removeLocation}{}}}
\subsection{Method \code{removeLocation()}}{
Removes a grant from the record metadata.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$removeLocation(place)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{place}}{place (required)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if removed, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-exportAs"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-exportAs}{}}}
\subsection{Method \code{exportAs()}}{
Exports record to a file by format.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$exportAs(format, filename, append_format = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{format}}{the export format to use. Possibles values are: BibTeX, CSL, DataCite, DublinCore, DCAT, 
JSON, JSON-LD, GeoJSON, MARCXML}

\item{\code{filename}}{the target filename (without extension)}

\item{\code{append_format}}{wether format name has to be appended to the filename. Default is \code{TRUE} (for
backward compatibility reasons). Set it to \code{FALSE} if you want to use only the \code{filename}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the writen file name (with extension)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-exportAsBibTeX"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-exportAsBibTeX}{}}}
\subsection{Method \code{exportAsBibTeX()}}{
Exports record as BibTeX
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$exportAsBibTeX(filename)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filename}}{the target filename (without extension)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the writen file name (with extension)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-exportAsCSL"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-exportAsCSL}{}}}
\subsection{Method \code{exportAsCSL()}}{
Exports record as CSL
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$exportAsCSL(filename)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filename}}{the target filename (without extension)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the writen file name (with extension)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-exportAsDataCite"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-exportAsDataCite}{}}}
\subsection{Method \code{exportAsDataCite()}}{
Exports record as DataCite
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$exportAsDataCite(filename)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filename}}{the target filename (without extension)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the writen file name (with extension)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-exportAsDublinCore"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-exportAsDublinCore}{}}}
\subsection{Method \code{exportAsDublinCore()}}{
Exports record as DublinCore
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$exportAsDublinCore(filename)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filename}}{the target filename (without extension)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the writen file name (with extension)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-exportAsDCAT"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-exportAsDCAT}{}}}
\subsection{Method \code{exportAsDCAT()}}{
Exports record as DCAT
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$exportAsDCAT(filename)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filename}}{the target filename (without extension)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the writen file name (with extension)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-exportAsJSON"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-exportAsJSON}{}}}
\subsection{Method \code{exportAsJSON()}}{
Exports record as JSON
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$exportAsJSON(filename)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filename}}{the target filename (without extension)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the writen file name (with extension)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-exportAsJSONLD"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-exportAsJSONLD}{}}}
\subsection{Method \code{exportAsJSONLD()}}{
Exports record as JSONLD
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$exportAsJSONLD(filename)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filename}}{the target filename (without extension)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-exportAsGeoJSON"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-exportAsGeoJSON}{}}}
\subsection{Method \code{exportAsGeoJSON()}}{
Exports record as GeoJSON
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$exportAsGeoJSON(filename)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filename}}{the target filename (without extension)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the writen file name (with extension)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-exportAsMARCXML"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-exportAsMARCXML}{}}}
\subsection{Method \code{exportAsMARCXML()}}{
Exports record as MARCXML
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$exportAsMARCXML(filename)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filename}}{the target filename (without extension)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the writen file name (with extension)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-exportAsAllFormats"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-exportAsAllFormats}{}}}
\subsection{Method \code{exportAsAllFormats()}}{
Exports record in all Zenodo record export formats. This function will
   create one file per Zenodo metadata formats.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$exportAsAllFormats(filename)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filename}}{the target filename (without extension)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-listFiles"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-listFiles}{}}}
\subsection{Method \code{listFiles()}}{
list files attached to the record
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$listFiles(pretty = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pretty}}{whether a pretty output (\code{data.frame}) should be returned (default \code{TRUE}), otherwise
the raw list of files is returned.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the files, as \code{data.frame} or \code{list}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-downloadFiles"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-downloadFiles}{}}}
\subsection{Method \code{downloadFiles()}}{
Downloads files attached to the record
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$downloadFiles(
  path = ".",
  files = list(),
  parallel = FALSE,
  parallel_handler = NULL,
  cl = NULL,
  quiet = FALSE,
  overwrite = TRUE,
  timeout = 60,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{target download path (by default it will be the current working directory)}

\item{\code{files}}{(list of) file(s) to download. If not specified, by default all files will be downloaded.}

\item{\code{parallel}}{whether download has to be done in parallel using the chosen \code{parallel_handler}. Default is \code{FALSE}}

\item{\code{parallel_handler}}{The parallel handler to use eg. \code{mclapply}. To use a different parallel handler (such as eg 
\code{parLapply} or \code{parSapply}), specify its function in \code{parallel_handler} argument. For cluster-based parallel 
download, this is the way to proceed. In that case, the cluster should be created earlier by the user with  \code{makeCluster}
and passed as \code{cl} argument. After downloading all files, the cluster will be stopped automatically.}

\item{\code{cl}}{an optional cluster for cluster-based parallel handlers}

\item{\code{quiet}}{(default is \code{FALSE}) can be set to suppress informative messages (not warnings).}

\item{\code{overwrite}}{(default is \code{TRUE}) can be set to FALSE to avoid re-downloading existing files.}

\item{\code{timeout}}{(default is 60s) see \code{download.file}.}

\item{\code{...}}{arguments inherited from \code{parallel::mclapply} or the custom \code{parallel_handler}
can be added (eg. \code{mc.cores} for \code{mclapply})}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-print"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-print}{}}}
\subsection{Method \code{print()}}{
Prints a \link{ZenodoRecord}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$print(..., format = "internal", depth = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{any other parameter. Not used}

\item{\code{format}}{format to use for printing. By default, \code{internal} uses an \pkg{zen4R} internal
printing method. Other methods available are those supported by Zenodo for record export, and can be used 
only if the record has already been published (with a DOI). Attemps to print using a Zenodo export format
for a record will raise a warning message and revert to "internal" format}

\item{\code{depth}}{an internal depth parameter for indentation of print statements, in case of listing or recursive use of print}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-toDCEntry"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-toDCEntry}{}}}
\subsection{Method \code{toDCEntry()}}{
Maps to an \pkg{atom4R} \link{DCEntry}. Note: applies only to published records.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$toDCEntry()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
an object of class \code{DCEntry}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZenodoRecord-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ZenodoRecord-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZenodoRecord$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
