% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/functions_package.R
\name{Zeta.order}
\alias{Zeta.order}
\title{Zeta diversity for a specific number of assemblages or sites}
\usage{
Zeta.order(data.spec, order = 1, sam = 1000)
}
\arguments{
\item{data.spec}{Site-by-species presence-absence data frame, with sites as rows and species as columns.}

\item{order}{Specific number of assemblages or sites at which zeta diversity is computed.}

\item{sam}{Number of samples for which the zeta-diversity is computed.}
}
\value{
\code{Zeta.order}  returns a list containing the following components:

\item{zeta.order}{The number of assemblages or sites for which the zeta-diversity was computed.}

\item{zeta.val}{The zeta-diversity values.}

\item{zeta.val.sd}{The zeta-diversity standard deviation values.}
}
\description{
Computes zeta diversity, the number of species shared by multiple assemblages, for a specific order (number of assemblages or sites).
}
\examples{
data(BCI.spec.coarse)
xy <- BCI.spec.coarse[1:2]
data.spec <- BCI.spec.coarse[3:308]

zeta <- Zeta.order(data.spec, order = 3, sam=100)
zeta

##########

data(Marion.species)
xy <- Marion.species[1:2]
data.species <- Marion.species[3:33]

zeta.species <- Zeta.order(data.species, order = 3, sam=100)
zeta.species
}
\references{
Hui C. & McGeoch M.A. (2014). Zeta diversity as a concept and metric that unifies incidence-based biodiversity patterns. \emph{The American Naturalist}, 184, 684-694.
}
\seealso{
\code{\link{Zeta.decline}}
}

