% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zip_helper_functions.R
\name{zip_distance}
\alias{zip_distance}
\title{Calculate the distance between two ZIP codes in miles}
\usage{
zip_distance(zipcode_a, zipcode_b, lonlat = TRUE, units = "miles")
}
\arguments{
\item{zipcode_a}{First vector of ZIP codes}

\item{zipcode_b}{Second vector of ZIP codes}

\item{lonlat}{lonlat argument to pass to raster::pointDistance() to select method of distance calculation. Default is TRUE to calculate distance over a spherical projection. FALSE will calculate the distance in Euclidean (planar) space.}

\item{units}{Specify which units to return distance calculations in. Choices include meters or miles.}
}
\value{
a data.frame containing a column for each ZIP code and a new column containing the distance between the two columns of ZIP code
}
\description{
Calculate the distance between two ZIP codes in miles
}
\examples{
zip_distance("08731", "08901")

}
