% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zipfpeFit.R
\name{zipfpeFit}
\alias{zipfpeFit}
\alias{residuals.zipfpeR}
\alias{fitted.zipfpeR}
\alias{coef.zipfpeR}
\alias{plot.zipfpeR}
\alias{print.zipfpeR}
\alias{summary.zipfpeR}
\alias{logLik.zipfpeR}
\alias{AIC.zipfpeR}
\alias{BIC.zipfpeR}
\title{Zipf-PE parameters estimation.}
\usage{
zipfpeFit(data, init_alpha = NULL, init_beta = NULL, level = 0.95, ...)

\method{residuals}{zipfpeR}(object, ...)

\method{fitted}{zipfpeR}(object, ...)

\method{coef}{zipfpeR}(object, ...)

\method{plot}{zipfpeR}(x, ...)

\method{print}{zipfpeR}(x, ...)

\method{summary}{zipfpeR}(object, ...)

\method{logLik}{zipfpeR}(object, ...)

\method{AIC}{zipfpeR}(object, ...)

\method{BIC}{zipfpeR}(object, ...)
}
\arguments{
\item{data}{Matrix of count data in form of table of frequencies.}

\item{init_alpha}{Initial value of \eqn{\alpha} parameter (\eqn{\alpha > 1}).}

\item{init_beta}{Initial value of \eqn{\beta} parameter (\eqn{\beta \in (-\infty, +\infty)}).}

\item{level}{Confidence level used to calculate the confidence intervals (default 0.95).}

\item{...}{Further arguments to the generic functions.The extra arguments are passing
to the \emph{\link{optim}} function.}

\item{object}{An object from class "zpeR" (output of \emph{zipfpeFit} function).}

\item{x}{An object from class "zpeR" (output of \emph{zipfpeFit} function).}
}
\value{
Returns an object composed by the maximum likelihood parameter estimations
jointly with their standard deviation and confidence intervals. It also contains
the value of the log-likelihood at the maximum likelihood estimator.
}
\description{
For a given sample of strictly positive integer values,  usually of the type of ranking data or
frequencies of frequencies data, estimates the parameters of the Zipf-PE
distribution by means of the maximum likelihood method. The input data should be provided as a frequency matrix.
}
\details{
The argument \code{data} is a two column matrix with the first column containing the observations and
the second column containing their frequencies.

The log-likelihood function is equal to:

\deqn{l(\alpha, \beta; x) = \beta\, (N - \zeta(\alpha)^{-1}\, \sum_{i = 1} ^m  f_{a}(x_{i})\, \zeta(\alpha, x_i)) +
\sum_{i = 1} ^m f_{a}(x_{i})\,  log \left( \frac{e^{\frac{\beta\, x_{i}^{-\alpha}}{\zeta(\alpha)}} - 1}{e^{\beta} - 1} \right), }
where \eqn{f_{a}(x_i)} is the absolute frequency of \eqn{x_i}, \eqn{m} is the number of different values in the sample and \eqn{N} is the sample size,
i.e.  \eqn{N = \sum_{i = 1} ^m x_i f_a(x_i)}.

By default the initial values of the parameters are computed using the function \code{getInitialValues}.

The function \emph{\link{optim}} is used to estimate the parameters.
}
\examples{
data <- rzipfpe(100, 2.5, 1.3)
data <- as.data.frame(table(data))
data[,1] <- as.numeric(levels(data[,1])[data[,1]])
initValues <- getInitialValues(data, model='zipfpe')
obj <- zipfpeFit(data, init_alpha = initValues$init_alpha, init_beta = initValues$init_beta)
}
\seealso{
\code{\link{getInitialValues}}.
}
