% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zipfpssMean.R
\name{zipfpssMean}
\alias{zipfpssMean}
\title{Expected value of the Zipf-PSS distribution.}
\usage{
zipfpssMean(alpha, lambda, isTruncated = FALSE)
}
\arguments{
\item{alpha}{Value of the \eqn{\alpha} parameter (\eqn{\alpha > 2}).}

\item{lambda}{Value of the \eqn{\lambda} parameter (\eqn{\lambda > 0}).}

\item{isTruncated}{Logical; if TRUE Use the zero-truncated version of the distribution to calculate the expected value (default = FALSE).}
}
\value{
A positive real value corresponding to the mean value of the distribution.
}
\description{
Computes the expected value of the Zipf-PSS distribution for given values of parameters
\eqn{\alpha} and \eqn{\lambda}.
}
\details{
The expected value of the Zipf-PSS distribution only exists for \eqn{\alpha} values strictly
greater than 2. The value is obtained from the \emph{law of total expectation} that says that: \deqn{E[Y] = E[N]\, E[X],}
where E[X] is the mean value of the Zipf distribution and E[N] is the expected value of a Poisson one.
From where one has that:
\deqn{E[Y] = \lambda\, \frac{\zeta(\alpha - 1)}{\zeta(\alpha)}}

Particularlly, if one is working with the zero-truncated version of the Zipf-PSS distribution.
This values is computed as:
\deqn{E[Y^{ZT}] = \frac{\lambda\, \zeta(\alpha - 1)}{\zeta(\alpha)\, (1 - e^{-\lambda})}}
}
\examples{
zipfpssMean(2.5, 1.3)
zipfpssMean(2.5, 1.3, TRUE)
}
\references{
{
Sarabia Alegría, J. M., Gómez Déniz, E. M. I. L. I. O., & Vázquez Polo, F. (2007).
Estadística actuarial: teoría y aplicaciones. Pearson Prentice Hall.
}
}
