% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zipfpssVariance.R
\name{zipfpssVariance}
\alias{zipfpssVariance}
\title{Variance of the Zipf-PSS distribution.}
\usage{
zipfpssVariance(alpha, lambda, isTruncated = FALSE)
}
\arguments{
\item{alpha}{Value of the \eqn{\alpha} parameter (\eqn{\alpha > 3}).}

\item{lambda}{Value of the \eqn{\lambda} parameter (\eqn{\lambda > 0}).}

\item{isTruncated}{Logical; if TRUE Use the zero-truncated version of the distribution to calculate the expected value (default = FALSE).}
}
\value{
A positive real value corresponding to the variance of the distribution.
}
\description{
Computes the variance of the Zipf-PSS distribution for given values of parameters
\eqn{\alpha} and \eqn{\lambda}.
}
\details{
The variance of the Zipf-PSS distribution only exists for \eqn{\alpha} values strictly greater than 3.
The value is obtained from the \emph{law of total variance} that says that: \deqn{Var[Y] = E[N]\, Var[X] + E[X]^2 \, Var[N],}
where X follows a Zipf distribution with parameter \eqn{\alpha}, and N follows a Poisson distribution with
parameter \eqn{\lambda}. From where one has that:

\deqn{Var[Y] = \lambda\, \frac{\zeta(\alpha - 2)}{\zeta(\alpha)}}
Particularlly, if one is working with the zero-truncated version of the Zipf-PSS distribution.
This values is computed as:
\deqn{Var[Y^{ZT}] = \frac{\lambda\, \zeta(\alpha)\, \zeta(\alpha - 2)\, (1 - e^{-\lambda}) - \lambda^2 \, \zeta(\alpha - 1)^2 \, e^{-\lambda}}{\zeta(\alpha)^2 \, (1 - e^{-\lambda})^2}}
}
\examples{
zipfpssVariance(4.5, 2.3)
zipfpssVariance(4.5, 2.3, TRUE)
}
\references{
{
Sarabia Alegría, JM. and Gómez Déniz, E. and Vázquez Polo, F. Estadística actuarial: teoría y aplicaciones. Pearson Prentice Hall.
}
}
