% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moezipfFit.R
\name{moezipfFit}
\alias{moezipfFit}
\alias{residuals.moezipfR}
\alias{fitted.moezipfR}
\alias{coef.moezipfR}
\alias{plot.moezipfR}
\alias{print.moezipfR}
\alias{summary.moezipfR}
\alias{logLik.moezipfR}
\alias{AIC.moezipfR}
\alias{BIC.moezipfR}
\title{MOEZipf parameters estimation.}
\usage{
moezipfFit(data, init_alpha = NULL, init_beta = NULL, level = 0.95,
  ...)

\method{residuals}{moezipfR}(object, ...)

\method{fitted}{moezipfR}(object, ...)

\method{coef}{moezipfR}(object, ...)

\method{plot}{moezipfR}(x, ...)

\method{print}{moezipfR}(x, ...)

\method{summary}{moezipfR}(object, ...)

\method{logLik}{moezipfR}(object, ...)

\method{AIC}{moezipfR}(object, ...)

\method{BIC}{moezipfR}(object, ...)
}
\arguments{
\item{data}{Matrix of count data in form of a table of frequencies.}

\item{init_alpha}{Initial value of \eqn{\alpha} parameter (\eqn{\alpha > 1}).}

\item{init_beta}{Initial value of \eqn{\beta} parameter (\eqn{\beta > 0}).}

\item{level}{Confidence level used to calculate the confidence intervals (default 0.95).}

\item{...}{Further arguments to the generic functions. The extra arguments are passing to the \emph{\link{optim}} function.}

\item{object}{An object from class "moezipfR" (output of \emph{moezipfFit} function).}

\item{x}{An object from class "moezipfR" (output of \emph{moezipfFit} function).}
}
\value{
Returns a \emph{moezipfR} object composed by the maximum likelihood parameter estimations
jointly with their standard deviation and confidence intervals. It also contains
the value of the log-likelihood at the maximum likelihood estimator.
}
\description{
For a given sample of strictly positive integer numbers,  usually of the type of ranking data or
frequencies of frequencies data, estimates the parameters of the MOEZipf distribution by means of
the maximum likelihood method. The input data should be provided as a frequency matrix.
}
\details{
The argument \code{data} is a two column matrix with the first column containing the observations and
the second column containing their frequencies.

The log-likelihood function is equal to:

\deqn{l(\alpha, \beta; x) = -\alpha \sum_{i = 1} ^m f_{a}(x_{i}) log(x_{i}) + N (log(\beta) + \log(\zeta(\alpha)))}
\deqn{ - \sum_{i = 1} ^m f_a(x_i) log[(\zeta(\alpha) - \bar{\beta}\zeta(\alpha, x_i)(\zeta(\alpha) - \bar{\beta}\zeta(\alpha, x_i + 1)))], }
where \eqn{f_{a}(x_i)} is the absolute frequency of \eqn{x_i}, \eqn{m} is the number of different values in the sample and \eqn{N} is the sample size,
i.e.  \eqn{N = \sum_{i = 1} ^m x_i f_a(x_i)}.

By default the initial values of the parameters are computed using the function \code{getInitialValues}.

The function \emph{\link{optim}} is used to estimate the parameters.
}
\examples{
data <- rmoezipf(100, 2.5, 1.3)
data <- as.data.frame(table(data))
data[,1] <- as.numeric(as.character(data[,1]))
data[,2] <- as.numeric(as.character(data[,2]))
initValues <- getInitialValues(data, model='moezipf')
obj <- moezipfFit(data, init_alpha = initValues$init_alpha, init_beta = initValues$init_beta)
}
\seealso{
\code{\link{getInitialValues}}.
}
