% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmmsim2.R
\name{hmmsim2}
\alias{hmmsim2}
\title{Simulate a hidden Markov series and its underlying states with covariates}
\usage{
hmmsim2(workparm, M, n, zeroindex, prior_x = NULL, tpm_x = NULL,
  emit_x = NULL, zeroinfl_x = NULL)
}
\arguments{
\item{workparm}{working parameters}

\item{M}{number of latent states}

\item{n}{length of the simulated series}

\item{zeroindex}{a vector specifying whether a certain state is zero-inflated}

\item{prior_x}{matrix of covariates for generalized logit of prior probabilites (excluding the 
1st probability). Default to NULL.}

\item{tpm_x}{matrix of covariates for transition probability matrix (excluding the 1st column).
Default to NULL.}

\item{emit_x}{matrix of covariates for the log poisson means. Default to NULL.}

\item{zeroinfl_x}{matrix of covariates for the nonzero structural zero proportions. Default to NULL.}
}
\value{
a matrix with 1st column of simulated series and 
2nd column of corresponding states
}
\description{
Simulate a hidden Markov series and its underlying states with covariates
}
\examples{
\dontrun{
priorparm <- 0
tpmparm <- c(0,-0.5,0.5,0,-0.2,0.8)
zeroindex <- c(1,0)
zeroparm <- c(0,-1,1)
emitparm <- c(2,0.5,-0.5,3,0.3,-0.2)
workparm <- c(priorparm,tpmparm,zeroparm,emitparm)

designx <- matrix(rnorm(2000),nrow=1000,ncol=2)
result <- hmmsim2(workparm,2,1000,zeroindex,tpm_x=designx,
      emit_x=designx,zeroinfl_x=designx)

y <- result$series

prior_init <- c(0.5,0.5)
emit_init <- c(10,30)
zero_init <- c(0.6,0)
omega <- matrix(c(0.9,0.1,0.2,0.8),2,2,byrow=TRUE)


fit <-  hmmfit(y,NULL,2,prior_init,omega,
     emit_init,zero_init, emit_x=designx,zeroinfl_x=designx,
     tpm_x=designx,hessian=FALSE,
     method="Nelder-Mead", control=list(maxit=2000,trace=1))

decode <- hmmviterbi2(y,NULL,2,fit$working_parameters,zero_init=c(1,0),
            emit_x=designx,zeroinfl_x=designx, tpm_x=designx,
            plot=TRUE, xlab="time", ylab="count",
            xlim=c(0,360),ylim=c(0,200))

sum(decode!=result$state)
}

}
\references{
Walter Zucchini, Iain L. MacDonald, Roland Langrock. Hidden Markov Models for 
Time Series: An Introduction Using R, Second Edition. Chapman & Hall/CRC
}

