% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zi_validate.R
\name{zi_validate}
\alias{zi_validate}
\title{Validate ZIP Code or ZCTA Vector}
\usage{
zi_validate(x, style = "zcta5", verbose = FALSE)
}
\arguments{
\item{x}{A vector containing ZIP or ZCTA values to be validated.}

\item{style}{A character scalar - either \code{"zcta5"} (default) or
\code{"zcta3"}.}

\item{verbose}{A logical scalar; if \code{FALSE} (default), an overall
evaluation will be returned. If \code{TRUE}, a \code{tibble} object
listing validation criteria and results will be returned.}
}
\value{
Either a logical value (if \code{verbose = FALSE}) or a \code{tibble}
    containing validation criteria and results.
}
\description{
This function validates vectors of ZIP Code or ZCTA values. It
    is used internally throughout \code{zippeR} for data validation, but
    is exported to facilitate troubleshooting.
}
\details{
The \code{zi_validate()} function checks for four conditions:
\itemize{
 \item{Is the input vector character data? This is important because of USPS's
     use of leading zeros in ZIP codes and ZCTAs.}
 \item{Are all values five characters (if \code{style = "zcta5"}, the default),
     or three characters (if \code{style = "zcta3"})?}
 \item{Are any input values over five characters (if \code{style = "zcta5"},
     the default), or three characters (if \code{style = "zcta3"})?}
 \item{Do any input values have non-numeric characters?}
}

The questions provide a basis for repairing issues identified with
\code{zi_repair()}.
}
\examples{
# sample five-digit ZIPs
zips <- c("63088", "63108", "63139")

# successful validation
zi_validate(zips)

# sample five-digit ZIPs in data frame
zips <- data.frame(id = c(1:3), ZIP = c("63139", "63108", "00501"), stringsAsFactors = FALSE)

# successful validation
zi_validate(zips$ZIP)

# sample five-digit ZIPs with character
zips <- c("63088", "63108", "zip")

# failed validation
zi_validate(zips)
zi_validate(zips, verbose = TRUE)

}
