% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{upload_forecast}
\alias{upload_forecast}
\title{Upload a forecast}
\usage{
upload_forecast(
  zoltar_connection,
  model_url,
  timezero_date,
  forecast_data,
  notes = ""
)
}
\arguments{
\item{zoltar_connection}{A `ZoltarConnection` object as returned by \code{\link{new_connection}}}

\item{model_url}{URL of a model in zoltar_connection's projects}

\item{timezero_date}{The date of the project timezero you are uploading for. it is a string in format YYYYMMDD}

\item{forecast_data}{Forecast data as a `list` in the Zoltar standard format}

\item{notes}{Optional user notes for the new forecast}
}
\value{
An UploadFileJob URL for the upload
}
\description{
This function submits forecast data to the server for uploading. Returns an UploadFileJob object that can be used to
up, which depends on the number of current uploads in the queue. Zoltar tracks these via `UploadFileJob` objects.)
}
\examples{
\dontrun{
  forecast_data <- jsonlite::read_json("docs-predictions.json")
  upload_file_job_url <- upload_forecast(conn, "http://www.zoltardata.com/api/model/1/",
                                         "2017-01-17", forecast_data, "a mid-January forecast")
}
}
