


use core::cmp::min;
use unix::solarish::*;

const PTEM: &[u8] = b"ptem\0";
const LDTERM: &[u8] = b"ldterm\0";

pub unsafe fn cfmakeraw(termios: *mut ::termios) {
    (*termios).c_iflag &=
        !(IMAXBEL | IGNBRK | BRKINT | PARMRK | ISTRIP | INLCR | IGNCR | ICRNL | IXON);
    (*termios).c_oflag &= !OPOST;
    (*termios).c_lflag &= !(ECHO | ECHONL | ICANON | ISIG | IEXTEN);
    (*termios).c_cflag &= !(CSIZE | PARENB);
    (*termios).c_cflag |= CS8;














    (*termios).c_cc[VMIN] = 1;
    (*termios).c_cc[VTIME] = 0;
}

pub unsafe fn cfsetspeed(termios: *mut ::termios, speed: ::speed_t) -> ::c_int {


    ::cfsetispeed(termios, speed);
    ::cfsetospeed(termios, speed);
    0
}

unsafe fn bail(fdm: ::c_int, fds: ::c_int) -> ::c_int {
    let e = *___errno();
    if fds >= 0 {
        ::close(fds);
    }
    if fdm >= 0 {
        ::close(fdm);
    }
    *___errno() = e;
    return -1;
}

pub unsafe fn openpty(
    amain: *mut ::c_int,
    asubord: *mut ::c_int,
    name: *mut ::c_char,
    termp: *const termios,
    winp: *const ::winsize,
) -> ::c_int {


    let fdm = ::posix_openpt(O_RDWR | O_NOCTTY);
    if fdm < 0 {
        return -1;
    }


    if ::grantpt(fdm) < 0 || ::unlockpt(fdm) < 0 {
        return bail(fdm, -1);
    }


    let subordpath = ::ptsname(fdm);
    if subordpath.is_null() {
        return bail(fdm, -1);
    }



    let fds = ::open(subordpath, O_RDWR | O_NOCTTY);
    if fds < 0 {
        return bail(fdm, -1);
    }


    let setup = ::ioctl(fds, I_FIND, LDTERM.as_ptr());
    if setup < 0 {
        return bail(fdm, fds);
    } else if setup == 0 {


        if ::ioctl(fds, I_PUSH, PTEM.as_ptr()) < 0 || ::ioctl(fds, I_PUSH, LDTERM.as_ptr()) < 0 {
            return bail(fdm, fds);
        }
    }


    if !termp.is_null() && ::tcsetattr(fds, TCSAFLUSH, termp) != 0 {
        return bail(fdm, fds);
    }


    if !winp.is_null() && ::ioctl(fds, TIOCSWINSZ, winp) < 0 {
        return bail(fdm, fds);
    }






    if !name.is_null() {
        ::strcpy(name, subordpath);
    }

    *amain = fdm;
    *asubord = fds;
    0
}

pub unsafe fn forkpty(
    amain: *mut ::c_int,
    name: *mut ::c_char,
    termp: *const termios,
    winp: *const ::winsize,
) -> ::pid_t {
    let mut fds = -1;

    if openpty(amain, &mut fds, name, termp, winp) != 0 {
        return -1;
    }

    let pid = ::fork();
    if pid < 0 {
        return bail(*amain, fds);
    } else if pid > 0 {


        ::close(fds);
        return pid;
    }




    ::close(*amain);





    if ::setsid() < 0
        || ::ioctl(fds, TIOCSCTTY, 0) < 0
        || ::dup2(fds, 0) < 0
        || ::dup2(fds, 1) < 0
        || ::dup2(fds, 2) < 0
    {



        ::_exit(EXIT_FAILURE);
    }


    if fds > 2 {
        ::close(fds);
    }

    0
}

pub unsafe fn getpwent_r(
    pwd: *mut passwd,
    buf: *mut ::c_char,
    buflen: ::size_t,
    result: *mut *mut passwd,
) -> ::c_int {
    let old_errno = *::___errno();
    *::___errno() = 0;
    *result = native_getpwent_r(
        pwd,
        buf,
        min(buflen, ::c_int::max_value() as ::size_t) as ::c_int,
    );

    let ret = if (*result).is_null() {
        *::___errno()
    } else {
        0
    };
    *::___errno() = old_errno;

    ret
}

pub unsafe fn getgrent_r(
    grp: *mut ::group,
    buf: *mut ::c_char,
    buflen: ::size_t,
    result: *mut *mut ::group,
) -> ::c_int {
    let old_errno = *::___errno();
    *::___errno() = 0;
    *result = native_getgrent_r(
        grp,
        buf,
        min(buflen, ::c_int::max_value() as ::size_t) as ::c_int,
    );

    let ret = if (*result).is_null() {
        *::___errno()
    } else {
        0
    };
    *::___errno() = old_errno;

    ret
}
