







use crate::imp_prelude::*;
use crate::RawDataClone;

impl<S: RawDataClone, D: Clone> Clone for ArrayBase<S, D> {
    fn clone(&self) -> ArrayBase<S, D> {

        unsafe {
            let (data, ptr) = self.data.clone_with_ptr(self.ptr);
            ArrayBase {
                data,
                ptr,
                dim: self.dim.clone(),
                strides: self.strides.clone(),
            }
        }
    }




    fn clone_from(&mut self, other: &Self) {
        unsafe {
            self.ptr = self.data.clone_from_with_ptr(&other.data, other.ptr);
            self.dim.clone_from(&other.dim);
            self.strides.clone_from(&other.strides);
        }
    }
}

impl<S: RawDataClone + Copy, D: Copy> Copy for ArrayBase<S, D> {}
