% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_plot.infl.R
\name{lm_plot.infl}
\alias{lm_plot.infl}
\title{Plot Leverage vs. Fitted Values to Visualize Inflential Observations}
\usage{
lm_plot.infl(
  mdl,
  ...,
  parms = lm_plot.parms(mdl),
  df = lm_plot.df(mdl, parms = parms)
)
}
\arguments{
\item{mdl}{A fitted model object (typically from \code{\link[stats]{lm}}).}

\item{...}{Additional arguments (not currently used).}

\item{parms}{List of plotting parameters, usually from \code{lm_plot.parms()}.}

\item{df}{Data frame with augmented model data. Defaults to \code{lm_plot.df(mdl)}.}
}
\value{
A \code{ggplot} object representing the comb plot of residuals vs sequence, indicating influential points. Included as an attribute \code{"parms"} is a list containing:
\itemize{
  \item \code{lim} Plotted limits on \code{x} and \code{y} axes.
}
}
\description{
Creates a plot of leverage values versus the linear fitted values, including an identification of points with a large Cook's distance, to visualize high-leverage and influential observations.
}
\details{
The plot visualizes the calculated leverage of individual data points, defined as the diagonal element of the 'hat' matrix, as a function of the fitted values and implicitly relative to their location in the field of predictor variables, and the threshold value of high leverage is indicated. In addition, Cook's distance can be used to label influential points, along with outlier and regular points.
}
\examples{

mdl <- lm(Sepal.Length ~ Sepal.Width, data = iris)
result <- lm_plot.infl(mdl)

}
\seealso{
\code{\link{lm_plot.df}}, \code{\link{lm_plot.parms}}, \code{\link{outlier}}
}
