% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cch.R
\name{trCCH}
\alias{trCCH}
\alias{trunc.CCH}
\title{Truncated Compound Confluent Hypergeometric function}
\usage{
trCCH(a, b, r, s, v, k, log = FALSE)
}
\arguments{
\item{a}{a > 0}

\item{b}{b > 0}

\item{r}{r  >= 0}

\item{s}{arbitrary}

\item{v}{0 < v}

\item{k}{arbitrary}

\item{log}{logical indicating whether to return values on the log scale; 
useful for Bayes Factor calculations}
}
\description{
Compute the Truncated Confluent Hypergeometric function from Li and Clyde
 (2018) which is the normalizing constant in the tcch density of Gordy
(1998) with integral representation:
}
\details{
tr.cch(a,b,r,s,v,k) =  Int_0^1/v
                    u^(a-1) (1 - vu)^(b -1) (k + (1 - k)vu)^(-r) exp(-s u) du

This uses a more 
stable method for calculating the normalizing constant using R's `integrate` 
function rather than the version in Gordy 1998. For calculating Bayes factors 
that use the `trCCH` function we 
recommend using the `log=TRUE` option to compute log Bayes factors.
}
\examples{

# special cases
# trCCH(a, b, r, s=0, v = 1, k) is the same as
# 2F1(a, r, a + b, 1 - 1/k)*beta(a, b)/k^r

k = 10; a = 1.5; b = 2; r = 2;  
trCCH(a, b, r, s=0, v = 1, k=k) *k^r/beta(a,b)
hypergeometric2F1(a, r, a + b, 1 - 1/k, log = FALSE)

# trCCH(a,b,0,s,1,1) is the same as 
# beta(a, b) 1F1(a, a + b, -s, log=FALSE)
s = 3; r = 0; v = 1; k = 1
beta(a, b)*hypergeometric1F1(a, a+b, -s, log = FALSE)
trCCH(a, b, r, s, v, k)

# Equivalence with the Phi1 function 
a = 1.5; b = 3; k = 1.25; s = 400;  r = 2;  v = 1; 

phi1(a, r,  a + b, -s, 1 - 1/k,  log=FALSE)*(k^-r)*gamma(a)*gamma(b)/gamma(a+b)
trCCH(a,b,r,s,v,k)
}
\references{
Gordy 1998 Li & Clyde 2018
}
\seealso{
Other special functions: 
\code{\link{hypergeometric1F1}()},
\code{\link{hypergeometric2F1}()},
\code{\link{phi1}()}
}
\author{
Merlise Clyde (\email{clyde@duke.edu})
}
\concept{special functions}
\keyword{math}
