% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BCEA-deprecated.R, R/mce.plot.R,
%   R/plot.mixedAn.R
\name{BCEA-deprecated}
\alias{BCEA-deprecated}
\alias{make.report}
\alias{mce.plot}
\alias{plot.mixedAn}
\title{Deprecated functions in package \pkg{BCEA}.}
\usage{
make.report(...)

mce.plot(mce, pos = c(1, 0.5), graph = c("base", "ggplot2"), ...)

plot.mixedAn(x, y.limits=NULL, pos=c(0,1), graph=c("base","ggplot2"),...)
}
\arguments{
\item{...}{Arguments to be passed to methods, such as graphical parameters
(see \code{\link[=par]{par()}}).}

\item{mce}{The output of the call to the function \code{\link[=multi.ce]{multi.ce()}}.}

\item{pos}{Parameter to set the position of the legend. Can be given in form
of a string \code{(bottom|top)(right|left)} for base graphics and
\code{bottom|top|left|right} for ggplot2. It can be a two-elements vector,
which specifies the relative position on the x and y axis respectively, or
alternatively it can be in form of a logical variable, with \code{FALSE}
indicating to use the default position and \code{TRUE} to place it on the
bottom of the plot. Default value is \code{c(0,1)}, that is in the topleft
corner inside the plot area.}

\item{graph}{A string used to select the graphical engine to use for
plotting. Should (partial-)match the two options \code{"base"} or
\code{"ggplot2"}. Default value is \code{"base"}. The \code{"plotly"} option is not
implemented for this particular graph.}

\item{x}{An object of class \code{mixedAn}, given as output of the call to
the function \code{\link[=mixedAn]{mixedAn()}}.}

\item{y.limits}{Range of the y-axis for the graph. The default value is
\code{NULL}, in which case the maximum range between the optimal and the
mixed analysis scenarios is considered.}
}
\value{
\item{mceplot}{ A ggplot object containing the plot. Returned only
if \code{graph="ggplot2"}. }

\item{evi}{ A ggplot object containing the plot. Returned only if
\code{graph="ggplot2"}. } The function produces a graph showing the
difference between the ''optimal'' version of the EVPI (when only the most
cost-effective intervention is included in the market) and the mixed
strategy one (when more than one intervention is considered in the market).
}
\description{
The functions listed below are deprecated and will be defunct in
the near future. When possible, alternative functions with similar
functionality are also mentioned. Help pages for deprecated functions are
available at \code{help("<function>-deprecated")}.

This function is deprecated. Use \code{\link[=ceac.plot]{ceac.plot()}} instead.
Plots the probability that each of the n_int interventions being analysed is
the most cost-effective.
}
\section{\code{plot.mixedAn}}{

For \code{plot.mixedAn}, use \code{\link[=evi.plot]{evi.plot()}}.

Summary plot of the health economic analysis when the mixed analysis is
considered

Compares the optimal scenario to the mixed case in terms of the EVPI.
}

\examples{

# See Baio G., Dawid A.P. (2011) for a detailed description of the 
# Bayesian model and economic problem

\dontrun{
# Load the processed results of the MCMC simulation model
data(Vaccine)
# 
# Runs the health economic evaluation using BCEA
m <- bcea(e=eff, c=cost,    # defines the variables of 
                            #  effectiveness and cost
      ref=2,                # selects the 2nd row of (e,c) 
                            #  as containing the reference intervention
      interventions=treats, # defines the labels to be associated 
                            #  with each intervention
      Kmax=50000,           # maximum value possible for the willingness 
                            #  to pay threshold; implies that k is chosen 
                            #  in a grid from the interval (0,Kmax)
      plot=FALSE            # inhibits graphical output
)
#
mce <- multi.ce(m)          # uses the results of the economic analysis 
#
mce.plot(mce,               # plots the probability of being most cost-effective
      graph="base")         #  using base graphics
#
if(require(ggplot2)){
mce.plot(mce,               # the same plot
      graph="ggplot2")      #  using ggplot2 instead
}
}

}
\references{
\insertRef{Baio2011}{BCEA}

\insertRef{Baio2013}{BCEA}
}
\seealso{
\code{\link[=BCEA-deprecated]{BCEA-deprecated()}}
}
\author{
Gianluca Baio, Andrea Berardi
}
\keyword{hplot}
\keyword{internal}
