% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizePedigree.R
\name{findFooest}
\alias{findFooest}
\title{Function to find the most extreme individuals in a pedigree
This function finds the most extreme individuals (oldest or youngest) in a pedigree. It is supposed to be used internally by the \code{summarize_pedigree} function.}
\usage{
findFooest(
  foo_summary_dt,
  sort_var,
  n_fooest,
  n_foo_total = nrow(foo_summary_dt),
  decreasing = FALSE
)
}
\arguments{
\item{sort_var}{A character string specifying the column to sort by.}

\item{n_fooest}{An integer specifying the number of individuals to return in the summary.}

\item{n_foo_total}{An integer specifying the total number of individuals in the summary.}

\item{decreasing}{A logical indicating whether to sort in decreasing order.}
}
\value{
A data.table with the top rows selected from \code{foo_summary_dt}.
}
\description{
Function to find the most extreme individuals in a pedigree
This function finds the most extreme individuals (oldest or youngest) in a pedigree. It is supposed to be used internally by the \code{summarize_pedigree} function.
}
\keyword{internal}
