% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdImportTextFile_hdf5}
\alias{bdImportTextFile_hdf5}
\title{Import Text File to HDF5}
\usage{
bdImportTextFile_hdf5(
  filename,
  outputfile,
  outGroup,
  outDataset,
  sep = NULL,
  header = FALSE,
  rownames = FALSE,
  overwrite = FALSE,
  paral = NULL,
  threads = NULL,
  overwriteFile = NULL
)
}
\arguments{
\item{filename}{Character string. Path to the input text file.}

\item{outputfile}{Character string. Path to the output HDF5 file.}

\item{outGroup}{Character string. Name of the group to create in HDF5 file.}

\item{outDataset}{Character string. Name of the dataset to create.}

\item{sep}{Character string (optional). Field separator, default is "\\t".}

\item{header}{Logical (optional). Whether first row contains column names.}

\item{rownames}{Logical (optional). Whether first column contains row names.}

\item{overwrite}{Logical (optional). Whether to overwrite existing dataset.}

\item{paral}{Logical (optional). Whether to use parallel processing.}

\item{threads}{Integer (optional). Number of threads for parallel processing.}

\item{overwriteFile}{Logical (optional). Whether to overwrite existing HDF5 file.}
}
\value{
List with components:
\describe{
\item{fn}{Character string with the HDF5 filename}
\item{ds}{Character string with the full dataset path to the imported data (group/dataset)}
\item{ds_rows}{Character string with the full dataset path to the row names}
\item{ds_cols}{Character string with the full dataset path to the column names}
}
}
\description{
Converts a text file (e.g., CSV, TSV) to HDF5 format, providing efficient
storage and access capabilities.
}
\details{
This function provides flexible text file import capabilities with support for:
\itemize{
\item Input format options:
\itemize{
\item Custom field separators
\item Header row handling
\item Row names handling
}
\item Processing options:
\itemize{
\item Parallel processing
\item Memory-efficient import
\item Configurable thread count
}
\item File handling:
\itemize{
\item Safe file operations
\item Overwrite protection
\item Comprehensive error handling
}
}

The function supports parallel processing for large files and provides
memory-efficient import capabilities.
}
\examples{
\dontrun{
library(BigDataStatMeth)

# Create a test CSV file
data <- matrix(rnorm(100), 10, 10)
write.csv(data, "test.csv", row.names = FALSE)

# Import to HDF5
bdImportTextFile_hdf5(
  filename = "test.csv",
  outputfile = "output.hdf5",
  outGroup = "data",
  outDataset = "matrix1",
  sep = ",",
  header = TRUE,
  overwriteFile = TRUE
)

# Cleanup
unlink(c("test.csv", "output.hdf5"))
}

}
\references{
\itemize{
\item The HDF Group. (2000-2010). HDF5 User's Guide.
}
}
\seealso{
\itemize{
\item \code{\link{bdCreate_hdf5_matrix}} for creating HDF5 matrices directly
}
}
