% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{CFfactor_coverage}
\alias{CFfactor_coverage}
\title{Coverage of time elements for each factor level}
\usage{
CFfactor_coverage(t, f, coverage = "absolute")
}
\arguments{
\item{t}{An instance of \link{CFTime}.}

\item{f}{factor or list. A factor or a list of factors derived from the
parameter \code{t}. The factor or list thereof should generally be generated by
the function \code{\link[=CFfactor]{CFfactor()}}.}

\item{coverage}{"absolute" or "relative".}
}
\value{
If \code{f} is a factor, a numeric vector with a length equal to the
number of levels in the factor, indicating the number of units from the
time series in \code{t} contained in each level of the factor when
\code{coverage = "absolute"} or the proportion of units present relative to the
maximum number when \code{coverage = "relative"}. If \code{f} is a list of factors, a
list with each element a numeric vector as above.
}
\description{
This function calculates the number of time elements, or the relative
coverage, in each level of a factor generated by \code{\link[=CFfactor]{CFfactor()}}.
}
\examples{
t <- CFtime("days since 2001-01-01", "365_day", 0:364)
f <- CFfactor(t, "dekad")
CFfactor_coverage(t, f, "absolute")
}
