% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv08_variability_chart.R
\name{cv08_variability_chart}
\alias{cv08_variability_chart}
\title{Variability Chart for Cleaning Events}
\usage{
cv08_variability_chart(data, cleaning_event_col, residue_pct_col, usl_pct_col)
}
\arguments{
\item{data}{A data frame containing the data to plot.}

\item{cleaning_event_col}{Name of the column representing cleaning events (as a string).}

\item{residue_pct_col}{Name of the column representing residue percentages (as a string).}

\item{usl_pct_col}{Name of the column representing the upper specification limit percentages (as a string).}
}
\value{
A ggplot object representing the variability chart.
}
\description{
This function generates a variability chart for cleaning events, showing data points, outliers,
and overall statistics like the grand mean and median.
}
\examples{
Eq_DAR <- cv01_dfclean(data=Eq_DAR, cleaning_event_col="CleaningEvent", 
residue_col="DAR", usl_col="USL" ) 
Eq_DAR <- cv03_usl_unification(data=Eq_DAR, cleaning_event_col="CleaningEvent", 
residue_col="DAR", usl_col="USL")
cv08_variability_chart(data=Eq_DAR, cleaning_event_col="CleaningEvent", 
residue_pct_col="DAR_Pct", usl_pct_col="USL_Pct")
}
\author{
Chan, Mohamed, Lou, Wendy, Yang, Xiande [xiande.yang at gmail.com]
}
