% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TTOT_fun.R
\name{TTOT_fun}
\alias{TTOT_fun}
\title{Compute the Total Time-on-Test (TTOT) Statistic}
\usage{
TTOT_fun(data, tA = 0, tB = 10000, t)
}
\arguments{
\item{data}{A data frame containing the input survival data.
The first column should be named \code{"Time"} and contain the observed survival times
(e.g., in months or years). The second column should be named \code{"Status"}, where
0 indicates a censored observation and 1 indicates an event.}

\item{tA}{Numeric. The starting time point for computing the Total Time-on-Test (TTOT) function.}

\item{tB}{Numeric. The ending time point for computing the TTOT function.}

\item{t}{Numeric. The time point(s) at which the TTOT function is evaluated.}
}
\value{
This function calculates the total time-on-test (TTOT) for a given dataset within the time interval (tA,tB).
}
\description{
Calculates the Total Time-on-Test (TTOT) statistic for a given vector of event times and censoring indicators. The TTOT function is commonly used in survival analysis for visualizing and assessing the cumulative hazard or comparing survival patterns between groups.
}
\examples{
# Generate sample survival data
set.seed(123)
sim_time <- generate_pe(n = 20, t = 1, lambda1 = 1, lambda2 = 0.5)
sim_status <- sample(c(0, 1), 20, replace = TRUE)
Data <- data.frame(Time = sim_time, Status = sim_status)
# Compute TTOT when time = 1
TTOT_fun(Data, t = 1)
}
