% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guidedParameterEstimation.R
\name{guidedModelSelection}
\alias{guidedModelSelection}
\title{Guided Model Selection}
\usage{
guidedModelSelection(data)
}
\arguments{
\item{data}{A vector of observations y}
}
\value{
A function, being a wrapper of DeCAFS with the selected parameter estimators.
}
\description{
This function aids the user in selecting an appropriate model for a given sequence of observations. 
The function goes an interactive visualization of different model fits for different choices of initial parameter estimators and l0 penalties (\code{beta}).
At the end, a call to the DeCAFS function is printed, while a DeCAFS wrapper is provvided.
}
\examples{
\dontrun{
y <- dataRWAR(1000, sdEta = 1, sdNu = 4, phi = .4, nbSeg = 4, jumpSize = 20, type = "updown")$y
DeCAFSWrapper <- guidedModelSelection(y)
}
}
