% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dinvgamma.R
\name{dinvgamma}
\alias{dinvgamma}
\title{Calculate inverse gamma distribution.}
\usage{
dinvgamma(x, shape, scale = 1, log = FALSE)
}
\arguments{
\item{x}{Input.}

\item{shape}{Shape parameter.}

\item{scale}{Scale parameter (1/rate).}

\item{log}{Whether to return the log density.}
}
\value{
Returns the density (or log density).
}
\description{
This function calculates the density of the inverse gamma distribution.
}
\examples{

# Draw samples from inverse gamma distribution with shape parameter 1 
# and scale parameter 1
samples = rinvgamma(100, shape=1, scale=1)

# Calculate density of samples
densities = dinvgamma(samples, shape=1, scale=1)

}
\author{
Frank Dondelinger
}
