% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residual_analysis.R
\name{construct_sde}
\alias{construct_sde}
\title{Construct Stochastic Differential Equation Model}
\usage{
construct_sde(
  drift,
  diffusion = NULL,
  variable = NULL,
  refine_with_gls = FALSE,
  gls_max_iter = 10,
  gls_tolerance = 1e-04,
  data = NULL,
  target = NULL
)
}
\arguments{
\item{drift}{Symbolic equation for the drift term f(.)}

\item{diffusion}{Variance model for the diffusion term g(.)}

\item{variable}{Name of the main state variable}

\item{refine_with_gls}{Use iterative GLS to refine estimates?}

\item{gls_max_iter}{Maximum iterations for GLS}

\item{gls_tolerance}{Convergence tolerance for GLS}

\item{data}{Data frame (required if refine_with_gls = TRUE)}

\item{target}{Target variable name (required if refine_with_gls = TRUE)}
}
\value{
An object of class "sde_model"
}
\description{
Combines a drift equation and diffusion model into a complete SDE:
dZ = f(Z, X, Y) dt + g(Z, X, Y) dW
}
