% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{suggest_differentiation_method}
\alias{suggest_differentiation_method}
\title{Suggest Differentiation Method Based on Data Characteristics}
\usage{
suggest_differentiation_method(Z, t = NULL)
}
\arguments{
\item{Z}{Numeric vector of observations.}

\item{t}{Numeric vector of time points.}
}
\value{
List with suggested method and diagnostic information.
}
\description{
Analyzes the time series to recommend the most appropriate differentiation
method based on detected features like trend, periodicity, shocks, and noise.
}
\examples{
t <- 1:100
Z <- 0.1 * t + rnorm(100) # Trend with noise
result <- suggest_differentiation_method(Z, t)
print(result$suggested_method)

}
