% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation.R
\name{createSccsSimulationSettings}
\alias{createSccsSimulationSettings}
\title{Create SCCS simulation settings}
\usage{
createSccsSimulationSettings(
  nSites = 5,
  n = 10000,
  atRiskTimeFraction = 0.1,
  timePartitions = 24,
  timeCovariates = 5,
  timeEffectSize = log(2),
  minBackgroundRate = 0.001,
  maxBackgroundRate = 0.01,
  rateRatio = 2,
  randomEffectSd = 0
)
}
\arguments{
\item{nSites}{Number of database sites to simulate.}

\item{n}{Number of subjects per site. Either a single number, or a vector of
length nSites.}

\item{atRiskTimeFraction}{Fraction of patient time when at risk (exposed). Either a single number, or a
vector of length nSites.}

\item{timePartitions}{Number of time partitions for seasonal covariates. Either a single number,
or a vector of length nSites.}

\item{timeCovariates}{Number of covariates to represent seasonality. Either a single number,
or a vector of length nSites.}

\item{timeEffectSize}{Strength of the seasonality effect. Either a single number,
or a vector of length nSites.}

\item{minBackgroundRate}{Minimum background outcome rate. Either a single number, or a vector of
length nSites.}

\item{maxBackgroundRate}{Maximum background outcome rate. Either a single number, or a vector of
length nSites.}

\item{rateRatio}{The incidence rate ratio.}

\item{randomEffectSd}{Standard deviation of the \code{log(hazardRatio)}. Fixed effect if equal to 0.}
}
\value{
An object of type \code{simulationSccsSettings}, to be used in the \code{\link[=simulatePopulations]{simulatePopulations()}} function.
}
\description{
Create an object specifying a simulation for the Self-Controlled Case Series (SCCS).
}
\examples{
settings <- createSccsSimulationSettings(nSites = 1, rateRatio = 2)
populations <- simulatePopulations(settings)

# Fit a SCCS regression for the simulated data site:
cyclopsData <- Cyclops::createCyclopsData(
  y ~ a + x1 + x2 + x3 + x4 + x5 + strata(stratumId) + offset(log(time)),
  data = populations[[1]],
  modelType = "cpr"
)
cyclopsFit <- Cyclops::fitCyclopsModel(cyclopsData)
coef(cyclopsFit)

# (Estimates in this example will vary due to the random simulation)

}
\seealso{
\link{simulatePopulations}
}
