\name{extBQuant}
\alias{extBQuant}
\title{Bayesian extreme quantile}
\usage{
extBQuant(
  threshold,
  postsamp,
  k,
  n,
  retp,
  alpha = 0.05,
  type = c("continuous", "discrete")
)
}
\arguments{
\item{threshold}{threshold for the generalized Pareto model, corresponding to the \eqn{n-k}th order statistic of the sample}

\item{postsamp}{a \code{m} by \code{2} matrix with columns containing the posterior samples of scale and shape parameters of the generalized Pareto distribution, respectively}

\item{k}{integer, number of exceedances for the generalized Pareto (only used if \code{extrapolation=TRUE})}

\item{n}{integer, number of observations in the full sample. Must be greater than \code{k}  (only used if \code{extrapolation=TRUE})}

\item{retp}{double indicating the value of the return period}

\item{alpha}{level for credibility interval. Default: 0.05 giving 95\% credibility intervals}

\item{type}{string indicating distribution types. Default: \code{c('continuous','discrete')}}
}
\value{
a list with components
\itemize{
\item \code{mQ} posterior mean of the extreme quantile
\item \code{ciQ} vector of dimension 2 returning the \eqn{\alpha/2} and \eqn{1-\alpha/2} empirical quantiles of the posterior distribution of the extreme quantile
}
}
\description{
Given posterior samples for the parameters of the continuous or discrete generalized Pareto distribution,
return the posterior mean and \eqn{1-\alpha} level credibility intervals of the extreme quantile
}
\examples{
\dontrun{
# generate data
set.seed(1234)
n <- 500
samp <- evd::rfrechet(500,0,3,4)
# set effective sample size and threshold
k <- 50
threshold <- sort(samp,decreasing = TRUE)[k+1]
# preliminary mle estimates of scale and shape parameters
mlest <- evd::fpot(samp, threshold)
# empirical bayes procedure
proc <- estPOT(
  samp,
  k = k,
  pn = c(0.01, 0.005),
  type = "continuous",
  method = "bayesian",
  prior = "empirical",
  start = as.list(mlest$estimate),
  sig0 = 0.1)
# extreme quantile corresponding to a return period of 100
extBQuant(
  proc$t,proc$post_sample,
  k,
  n,
  100,
  0.05,
  type = "continuous")
}
}
