% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_power.R
\name{average.power.ranksum}
\alias{average.power.ranksum}
\title{Compute average power of rank-sum tests}
\usage{
average.power.ranksum(n, alpha, p)
}
\arguments{
\item{n}{sample size (scalar)}

\item{alpha}{p-value threshold (scalar)}

\item{p}{Pr(Y>X), as in Noether (JASA 1987)}
}
\value{
Average power estimate for multiple testing procedure
}
\description{
Compute average power of rank-sum tests
}
\examples{
p = rep(c(0.8,0.5),c(100,900));
average.power.ranksum(n = 50, alpha = 0.05, p=p)
}
\seealso{
\code{\link{power.ranksum}} for more details about power calculation of rank-sum test. The power calculation is based on asymptotic normal approximation.
}
