% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplesize.R
\name{n.fdr.signrank}
\alias{n.fdr.signrank}
\title{Sample size calculation for signed-rank tests}
\usage{
n.fdr.signrank(fdr, pwr, p1, p2, pi0.hat = "BH")
}
\arguments{
\item{fdr}{desired FDR (scalar numeric)}

\item{pwr}{desired average power (scalar numeric)}

\item{p1}{Pr(X>0), as in Noether (JASA 1987)}

\item{p2}{Pr(X+X'>0), as in Noether (JASA 1987)}

\item{pi0.hat}{method to estimate proportion \code{pi0} of tests with true null, including: "HH" (p-value histogram height) , "HM" (p-value histogram mean), "BH" (Benjamini & Hochberg 1995), "Jung" (Jung 2005)}
}
\value{
A list with the following components:
\item{n}{sample size estimate}
\item{computed.avepow}{average power}
\item{desired.avepow}{desired average power}
\item{desired.fdr}{desired FDR}
\item{input.pi0}{proportion of tests with a true null hypothesis}
\item{alpha}{fixed p-value threshold for multiple testing procedure}
\item{n.its}{number of iteration}
\item{max.its}{maximum number of iteration, default is 50}
\item{n0}{lower limit for initial sample size range}
\item{n1}{upper limit for initial sample size range}
}
\description{
Find the sample size needed to have a desired false discovery rate and average power for a large number of signed-rank tests.
}
\examples{
p1 = rep(c(0.8,0.5),c(100,900));
p2 = rep(c(0.8,0.5),c(100,900));
n.fdr.signrank(fdr = 0.1, pwr = 0.8, p1 = p1, p2 = p2, pi0.hat = "BH")
}
\references{
Noether, Gottfried E (1987) Sample size determination for some common nonparametric tests. Journal of the American Statistical Association, 82:645-647.
}
