% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_constructors.R
\name{design_constructors}
\alias{design_constructors}
\alias{design_boin}
\alias{design_i3plus3}
\alias{design_mtpi2}
\alias{design_g3plus3}
\alias{design_3plus3}
\title{Design Constructor Functions}
\usage{
design_boin(
  pT,
  EI,
  npts = 12,
  ncohort = NULL,
  cohortsize = 3,
  startdose = 1,
  DU.pp = 0.95,
  n.earlystop = 100,
  extrasafe = FALSE,
  ntrial = 1000,
  seed = 6
)

design_i3plus3(
  pT,
  EI,
  npts = 12,
  ncohort = NULL,
  cohortsize = 3,
  startdose = 1,
  DU.pp = 0.95,
  n.earlystop = 100,
  extrasafe = FALSE,
  ntrial = 1000,
  seed = 6
)

design_mtpi2(
  pT,
  EI,
  npts = 12,
  ncohort = NULL,
  cohortsize = 3,
  startdose = 1,
  DU.pp = 0.95,
  n.earlystop = 100,
  extrasafe = FALSE,
  ntrial = 1000,
  seed = 6
)

design_g3plus3(
  npts = 12,
  ncohort = NULL,
  cohortsize = 3,
  startdose = 1,
  DU.pp = 0.95,
  n.earlystop = 100,
  ntrial = 1000,
  seed = 6
)

design_3plus3(
  npts = 12,
  ncohort = NULL,
  cohortsize = 3,
  startdose = 1,
  ntrial = 1000,
  seed = 6
)
}
\arguments{
\item{pT}{a numeric value; the target DLT rate.}

\item{EI}{a vector of length 2; the equivalence interval (EI).}

\item{npts}{a numeric value; the number of participants for decision table generation.}

\item{ncohort}{a numeric value; the total number of cohorts for simulation.}

\item{cohortsize}{a numeric value; the cohort size (default: 3).}

\item{startdose}{a numeric value; the starting dose level (default: 1).}

\item{DU.pp}{a numeric value; the cutoff to remove an overly toxic dose (default: 0.95).}

\item{n.earlystop}{a numeric value; early stopping parameter (default: 100).}

\item{extrasafe}{a logical value; whether to implement extra safety rule (default: FALSE).}

\item{ntrial}{a numeric value; the total number of simulated trials (default: 1000).}

\item{seed}{a numeric value; random seed for simulation (default: 6).}
}
\value{
An S3 object of class \code{boin_design}, \code{i3plus3_design}, \code{mtpi2_design},
        \code{g3plus3_design}, or \code{threethree_design} containing the design specifications.
}
\description{
Constructor functions to create design specification objects for Phase I dose-finding trials.
}
\examples{
# Create a BOIN design specification
boin <- design_boin(pT = 0.25, EI = c(0.15, 0.35), npts = 12)

# Create an i3+3 design specification
i3 <- design_i3plus3(pT = 0.25, EI = c(0.2, 0.3), npts = 12)

}
