% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DPedge.R
\name{DPedge}
\alias{DPedge}
\title{The edge-exploited version of DPmatching.}
\usage{
DPedge(A = NULL, B = NULL, d, W = NULL)
}
\arguments{
\item{A, B}{Two symmetric 0/1 addjacency matrices.}

\item{d}{A positive integer, indicating the number of candidate matching.}

\item{W}{A distance matrix between \code{A} and \code{B}. This argumnet can
be null. If \code{W} is null, \code{A} and \code{B} cannot be null.}
}
\value{
\item{Dist}{The distance matrix between two graphs.} \item{Z}{An
  indicator matrix. Entry \eqn{Z_{i, j} = 1} indicates a matching between
  node \code{i} in graph \code{A} and node \code{j} in graph \code{B}, 0
  otherwise.}
}
\description{
This functions is based on \emph{DPmatching}. Instead of
  allowing each vertex in \emph{A} to connect to one and only one vertex in
  \emph{B}, here by introducing parameter \code{d}, this function allows for
  \code{d} edges for each vertex in \emph{A}. More details are in
  \emph{DPmatching}.
}
\examples{
set.seed(2020)
n = 10; q = 1/2; s = 1; p = 1
Parent = matrix(rbinom(n*n, 1, q), nrow = n, ncol = n)
Parent[lower.tri(Parent)] = t(Parent)[lower.tri(Parent)]
diag(Parent) <- 0
### Generate graph A
dA = matrix(rbinom(n*n, 1, s), nrow = n, ncol=n);
dA[lower.tri(dA)] = t(dA)[lower.tri(dA)]
A1 = Parent*dA
tmp = rbinom(n, 1, p)
n.A = length(which(tmp == 1))
indA = sample(1:n, n.A, replace = FALSE)
A = A1[indA, indA]
### Generate graph B
dB = matrix(rbinom(n*n, 1, s), nrow = n, ncol=n);
dB[lower.tri(dB)] = t(dB)[lower.tri(dB)]
B1 = Parent*dB
tmp = rbinom(n, 1, p)
n.B = length(which(tmp == 1))
indB = sample(1:n, n.B, replace = FALSE)
B = B1[indB, indB]
DPmatching(A, B)
W = DPdistance(A, B)
DPedge(A, B, d = 5)
}
