% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChainedSuppression.R
\name{ChainedSuppression}
\alias{ChainedSuppression}
\alias{ChainedSuppressionHi}
\alias{ChainedSuppressionHi1}
\title{Repeated GaussSuppression  with forwarding of previous results}
\usage{
ChainedSuppression(..., withinArg = NULL)

ChainedSuppressionHi(..., hierarchies)

ChainedSuppressionHi1(..., hierarchies)
}
\arguments{
\item{...}{Arguments to \code{AdditionalSuppression}/\code{GaussSuppressionFromData} that are kept constant.}

\item{withinArg}{A list of named lists. Arguments to \code{AdditionalSuppression}/\code{GaussSuppressionFromData} that are not kept constant.
List elements with suppressed data are also allowed.}

\item{hierarchies}{In the wrapper \code{ChainedSuppressionHi}, this argument will be used to generate the
\code{withinArg} to \code{ChainedSuppression} with the same length (see examples).
Then, element number \code{i} of \code{withinArg} is \code{list(hierarchies = hierarchies[1:i])}.
In the similar wrapper, \code{ChainedSuppressionHi1}, \code{withinArg} has always two elements:
\code{list(hierarchies = hierarchies[1])} and
\code{list(hierarchies = hierarchies)}.}
}
\value{
List of data frames. The wrappers, \code{ChainedSuppressionHi} and \code{ChainedSuppressionHi1},
return a single data frame, which is the last list item.
}
\description{
\code{\link{AdditionalSuppression}} is called several times. Each time with all previous  results as \code{suppressedData}.
}
\examples{

z1 <- SSBtoolsData("z1")
z2 <- SSBtoolsData("z2")
z2b <- z2[3:5]
names(z2b)[1] <- "region"

# As GaussSuppressionFromData when a single element within withinArg
a1 <- ChainedSuppression(z1, 1:2, 3, maxN = 5)
a2 <- ChainedSuppression(z1, withinArg = list(list(dimVar = 1:2, freqVar = 3, maxN = 5)))
identical(a1, a2[[1]])

# b[[3]] include results from b[[1]] and b[[2]]
b <- ChainedSuppression(z1, freqVar = 3, withinArg = list(
       list(dimVar = 1,   maxN = 55), 
       list(dimVar = 2,   maxN = 55), 
       list(dimVar = 1:2, maxN = 5)))

# d[[2]] is same as b1 in AdditionalSuppression examples
d <- ChainedSuppression(withinArg = list(
       list(data = z1,  dimVar = 1:2, freqVar = 3, maxN = 5), 
       list(data = z2,  dimVar = 1:4, freqVar = 5, maxN = 1)))

# Common variable names important. 
# Therefore kostragr renamed to region in z2b. 
f <- ChainedSuppression(withinArg = list(
       list(data = z1,  dimVar = 1:2, freqVar = 3, maxN = 5), 
       list(data = z2b, dimVar = 1:2, freqVar = 3, maxN = 5), 
       list(data = z2,  dimVar = 1:4, freqVar = 5, maxN = 1)))

# Parameters so that only suppressions are forwarded. 
# This is first iteration in linked tables by iterations. 
e <- ChainedSuppression(withinArg = list(
       list(data = z1,  dimVar = 1:2, freqVar = 3, maxN = 5), 
       list(data = z2b, dimVar = 1:2, freqVar = 3, maxN = 5), 
       list(data = z2,  dimVar = 1:4, freqVar = 5, maxN = 1)), 
       makeForced = FALSE, forceNotPrimary = FALSE)
       
# "A" "annet"/"arbeid" could be suppressed here, but not in f since f[[1]]      
e[[3]][which(e[[3]]$suppressed != f[[3]]$suppressed), ]  


#### Demonstrate SuppressionByChainedHierarchies

dimLists <- SSBtools::FindDimLists(z2[, 4:1])


# Two ways of doing the same calculations
g1 <- ChainedSuppressionHi(z2, c(1, 3), 5, maxN = 1, hierarchies = dimLists)
g1b <-  ChainedSuppression(z2, c(1, 3), 5, maxN = 1, withinArg = list(
         list(hierarchies = dimLists[1]),
         list(hierarchies = dimLists[1:2]),
         list(hierarchies = dimLists[1:3])))[[3]]      
       
# Results different after combining hierarchies      
g2 <- ChainedSuppressionHi(z2, c(1, 3), 5, maxN = 1, 
         hierarchies = SSBtools::AutoHierarchies(dimLists))        
       
# In this case, the same results can be obtained by:         
g3 <- ChainedSuppressionHi1(z2, c(1, 3), 5, maxN = 1, hierarchies = dimLists)        
       
}
