% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fplot.R
\name{fplot}
\alias{fplot}
\title{Plot line or bar graphic}
\usage{
fplot(
  data,
  type = "bar",
  x,
  y,
  group = NA,
  xlab = NA,
  ylab = NA,
  glab = NA,
  ylimits = NA,
  xrotation = NA,
  xtext = NA,
  gtext = NA,
  legend = "top",
  sig = NA,
  sigsize = 3,
  error = NA,
  color = TRUE,
  opt = NA
)
}
\arguments{
\item{data}{Output from ger_testcomp function}

\item{type}{Type of graphic. "bar" or "line"}

\item{x}{Axis x variable}

\item{y}{Axis y variable}

\item{group}{Group variable}

\item{xlab}{Title for the axis x}

\item{ylab}{Title for the axis y}

\item{glab}{Title for the legend}

\item{ylimits}{limits of the y axis}

\item{xrotation}{Rotation in x axis c(angle, h, v)}

\item{xtext}{Text labels in x axis}

\item{gtext}{Text labels in groups}

\item{legend}{the position of legends ("none", "left", "right", "bottom", "top", or two-element numeric vector)}

\item{sig}{Column with the significance}

\item{sigsize}{Font size in significance letters}

\item{error}{Show the error bar ("ste" or "std").}

\item{color}{colored figure c(TRUE, FALSE) or vector with the color.}

\item{opt}{Add news layer to the plot}
}
\value{
Line o bar plot
}
\description{
Function use the dtsm function for plot the results
}
\examples{
 

\dontrun{

library(GerminaR)
library(dplyr)

smr <- ger_summary(SeedN = "seeds"
                   , evalName = "D"
                   , data = prosopis) \%>\%
  mutate(across(rep:temp, as.factor))
  
av <- aov(grp ~ nacl*temp, smr)

anova(av)

mc <- ger_testcomp(aov = av
                   , comp = c("nacl", "temp"))
                   
plotdt <- mc$table
                    
plot <- fplot(data = plotdt
       , type = "bar"
       , x = "temp"
       , y = "grp"
       , group = "nacl"
       , sig = "sig"
       #, error = "ste"
       , color = T
       , ylimits = c(0, 120, 20)
       )
       
plot
       
} 

}
