% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MKWP.R
\name{mkwp}
\alias{mkwp}
\title{Find changepoints in multivariate data}
\usage{
mkwp(data, depth = c("spat", "mahal", "mahal75", "hs"), k = 0.2)
}
\arguments{
\item{data}{Data in \code{matrix} or \code{data.frame} form, where each row is an
observation and each column is a dimension.}

\item{depth}{Depth function.}

\item{k}{Penalty constant passed to pruned exact linear time algorithm.}
}
\value{
A list consisting of:
\itemize{
\item \verb{$changepoints} : Indices of the changepoints detected; will return \code{integer(0)} if no changepoints are detected.
\item \verb{$method} : A \code{string} \code{"Multivariate Kruskal-Wallis PELT (MKWP)"}
}
}
\description{
The \code{mkwp()} function detects changepoints in multivariate data using
multivariate Kruskal-Wallis PELT (MKWP) algorithm developed by Ramsay and
Chenouri (2023).
}
\note{
The options for the \code{depth} argument are as follows:
\itemize{
\item \code{spat}: Spatial depth
\item \code{hs}: Halfspace depth
\item \code{mahal}: Mahalanobis depth
\item \code{mahal75}: Mahalanobis depth based on re-weighted Minimum Covariance Determinant with 25\% breakdown.

Spatial depth is the default choice, as it computationally quicker than the
other depths for larger data while giving similar result to other depths.
}

The penalty is of the form \deqn{3.74 + k\sqrt{n}} where \eqn{n} is the
number of observations. In the case that there is potentially correlated
observations, the parameter could be set to \eqn{k=1}. More information
could be found in the reference.
}
\examples{
set.seed(111)
multi_data <-rbind(replicate(3,rnorm(200)),
                   replicate(3,rnorm(200,10)),
                   replicate(3,rnorm(200,0.2)))
mkwp(multi_data)

}
\references{
Killick, R., P. Fearnhead, and I. A. Eckley. “Optimal Detection
of Changepoints With a Linear Computational Cost.” Journal of the American
Statistical Association 107, no. 500 (2012): 1590–98.
https://doi.org/10.1080/01621459.2012.737745.

Ramsay, K., & Chenouri, S. (2023). Robust nonparametric multiple
changepoint detection for multivariate variability. Econometrics and
Statistics. https://doi.org/10.1016/j.ecosta.2023.09.001
}
