% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPC.R
\name{SPC}
\alias{SPC}
\title{Apply the SPC method to the Laplace factor model}
\usage{
SPC(data, m, gamma)
}
\arguments{
\item{data}{The data used in the SPC analysis.}

\item{m}{is the number of principal component}

\item{gamma}{is a sparse parameter}
}
\value{
A list containing:
\item{As}{Estimated factor loadings, a matrix of estimated factor loadings from the SPC analysis.}
\item{Ds}{Estimated uniquenesses, a vector of estimated uniquenesses corresponding to each variable.}
}
\description{
This function performs Sparse Principal Component Analysis (SPC) on the input data. It estimates factor loadings and uniquenesses while calculating mean squared errors and loss metrics for comparison with true values.
}
\examples{
library(LaplacesDemon)
library(MASS)
n=1000
p=10
m=5
mu=t(matrix(rep(runif(p,0,1000),n),p,n))
mu0=as.matrix(runif(m,0))
sigma0=diag(runif(m,1))
F=matrix(mvrnorm(n,mu0,sigma0),nrow=n)
A=matrix(runif(p*m,-1,1),nrow=p)
lanor <- rlaplace(n*p,0,1)
epsilon=matrix(lanor,nrow=n)
D=diag(t(epsilon)\%*\%epsilon)
data=mu+F\%*\%t(A)+epsilon
results <- SPC(data, m, gamma=0.03)
print(results)
}
