% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ECMEBoot.R
\name{ECMEBoot}
\alias{ECMEBoot}
\title{Bootstrap standard errors for the MLEs of a lognormal-Pareto mixture}
\usage{
ECMEBoot(x, y, eps, maxiter)
}
\arguments{
\item{x}{list: sequence of integers 1,...,K, where K is the mumber of datasets. Set x = 1 in case
of a single dataset.}

\item{y}{numerical vector: observed sample.}

\item{eps}{non-negative scalar: starting value of the log-expectation of the lognormal distribution on the log scale.}

\item{maxiter}{non-negative integer: maximum number of iterations of the ECME algorithm.}
}
\value{
Estimated parameters obtained from a bootstrap sample.
}
\description{
This function draws a bootstrap sample and uses it to estimate the parameters of a lognormal-Pareto mixture distribution. Since this is typically called by LPfitEM, see the help of LPfitEM for examples.
}
\details{
At each bootstrap replication, the mixture is estimated via the ECME algorithm. The function is typically called by LPfitEM.
}
