% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Helper_functions.R
\name{convert_cir_to_age}
\alias{convert_cir_to_age}
\title{Convert cumulative incidence rate to age}
\usage{
convert_cir_to_age(cir, pop_prev = 0.1, mid_point = 60, slope = 1/8)
}
\arguments{
\item{cir}{A positive number representing the individual's cumulative
incidence rate.}

\item{pop_prev}{A positive number representing the overall
population prevalence. Must be at most 1 and must be larger than
cir. Defaults to 0.1.}

\item{mid_point}{A positive number representing the mid point
logistic function. Defaults to 60.}

\item{slope}{A number holding the rate of increase.
Defaults to 1/8.}
}
\value{
If cir and mid_point are positive numbers, if pop_prev
is a positive number between 0 and 1 and if slope is a valid number,
then \code{convert_cir_to_age} returns a number, which is equal to
the current age.
}
\description{
\code{convert_cir_to_age} computes the age
from a person's cumulative incidence rate.
}
\details{
Given a person's cumulative incidence rate (cir), \code{convert_cir_to_age}
can be used to compute the corresponding age, which is given by
\deqn{mid\_ point - \log(pop\_ prev/cir - 1) * 1/slope}
}
\examples{
curve(sapply(cir, convert_cir_to_age), from = 0.001, to = 0.099, xname = "cir") 
}
