% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qreml_functions.R
\name{penalty_uni}
\alias{penalty_uni}
\title{Penalty approximation of unimodality constraints for univariates smooths}
\usage{
penalty_uni(coef, m, kappa = 1000, concave = TRUE, rho = 20)
}
\arguments{
\item{coef}{coefficient vector of matrix on which to apply the unimodality penalty}

\item{m}{vector of indices for the position of the coefficient mode. 
If \code{coef} is a vector, must be of length 1. Otherwise, must be of length equal to nrow(coef)}

\item{kappa}{global scaling factor for the penalty}

\item{concave}{logical; if \code{TRUE} (default), the penalty enforces increasing until the mode then decreasing. If the coefficients should decrease until the mode, then increase, set \code{concave = FALSE}.}

\item{rho}{control parameter for smooth approximation to \code{min(x, 0)} used internally. 
For large values, gets closer to true minimum function but less stable.}
}
\value{
a numeric value of the penalty for the given coefficients
}
\description{
Penalty approximation of unimodality constraints for univariates smooths
}
\examples{
## coefficient vector
coef <- c(1, 2, 3, 2, 1)
# mode at position 3
penalty_uni(coef, m = 3) # basically zero
#' # mode at position 2
penalty_uni(coef, m = 2) # large positive penalty

## coefficient matrix
coef <- rbind(coef, coef)
m <- c(1, 4)
penalty_uni(coef, m)
}
