% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AndersonDarling.R
\name{AndersonDarling}
\alias{AndersonDarling}
\alias{distribution.ad}
\title{Two-Sample Anderson-Darling Test}
\description{
Performs two-sample Anderson-Darling test on samples.
}
\examples{
pmt(
    "distribution.ad", n_permu = 0
)$test(Table2.8.1)$print()

}
\section{Super classes}{
\code{\link[LearnNonparam:PermuTest]{LearnNonparam::PermuTest}} -> \code{\link[LearnNonparam:TwoSampleTest]{LearnNonparam::TwoSampleTest}} -> \code{\link[LearnNonparam:TwoSampleDistributionTest]{LearnNonparam::TwoSampleDistributionTest}} -> \code{AndersonDarling}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AndersonDarling-new}{\code{AndersonDarling$new()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="plot"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-plot'><code>LearnNonparam::PermuTest$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="print"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-print'><code>LearnNonparam::PermuTest$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="test"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-test'><code>LearnNonparam::PermuTest$test()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AndersonDarling-new"></a>}}
\if{latex}{\out{\hypertarget{method-AndersonDarling-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{AndersonDarling} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AndersonDarling$new(
  alternative = c("two_sided", "less", "greater"),
  n_permu = 10000
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alternative}}{a character string specifying the alternative hypothesis.}

\item{\code{n_permu}}{an integer indicating number of permutations for the permutation distribution. If set to \code{0}, all permutations will be used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{AndersonDarling} object.
}
}
}
