% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.pmcid.R
\name{cv.pmcid}
\alias{cv.pmcid}
\title{Selection of the tuning parameter for determining the MCID at the population level}
\usage{
cv.pmcid(x, y, delseq, k = 5, maxit = 100, tol = 0.01)
}
\arguments{
\item{x}{a continuous variable denoting the outcome change of interest}

\item{y}{a binary variable indicating the patient-reported outcome derived from the anchor question}

\item{delseq}{a vector containing the candidate values for the tuning parameter \eqn{\delta}, where \eqn{\delta} is used to control the difference between the 0-1 loss and the surrogate loss.
We recommend selecting the possible values from the neighborhood of the standard deviation of x}

\item{k}{the number of groups into which the data should be split to select the tuning parameter \eqn{\delta} by cross-validation. Defaults to 5}

\item{maxit}{the maximum number of iterations. Defaults to 100}

\item{tol}{the convergence tolerance. Defaults to 0.01}
}
\value{
a list including the selected tuning parameter and the value of the corresponding target function
}
\description{
\code{cv.pmcid} returns the optimal tuning parameter \eqn{\delta} selected from a given grid by using k-fold cross-validation.
The tuning parameter is selected for determining the MCID at the population level
}
\examples{
n <- 500
deltaseq <- seq(0.1, 1, 0.1)
a <- 0.2
b <- -0.1
p <- 0.5

set.seed(115)
y <- 2 * rbinom(n, 1, p) - 1
y_1 <- which(y == 1)
y_0 <- which(y == -1)
x <- c()
x[y_1] <- rnorm(length(y_1), a, 0.1)
x[y_0] <- rnorm(length(y_0), b, 0.1)

sel <- cv.pmcid(x = x, y = y, delseq = deltaseq, k = 5,
         maxit = 100, tol = 1e-02)
sel$'Selected delta'
sel$'Function value'

}
