% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NestTablesXL_func_20221012.R
\name{NestTablesXL}
\alias{NestTablesXL}
\title{NestTablesXL() function}
\usage{
NestTablesXL(nest_table, seq_table, filepath, path_out)
}
\arguments{
\item{nest_table}{is a table containing the sample names of parents and
offspring in each nest. This table should be organized so that the
individual names are in the first column (Sample_ID), and the nest number
is in the second column (Nest). For each nest, the first two rows should be
the parents, followed immediately by the offspring in the subsequent rows,
and then followed by the next nest, and so on. It is assumed that nests are
numbered consecutively beginning at 1. Please use the same table as was used
to generate the haplotypes using HpltFind().}

\item{seq_table}{seq_table is a sequence table as output by the 'dada2'
pipeline, which has samples in rows and nucleotide sequence variants in
columns. Please use the same table as was used to generate the haplotypes
using HpltFind().}

\item{filepath}{is a user defined path to the folder where the output files
from the HpltFind() function have been saved.}

\item{path_out}{is a user defined path to the folder where the output file
will be saved.}
}
\value{
An Excel workbook with individual tabs for each nest in nest_table.
  Each tab contains a binary (logical) occurrence matrix with the samples from
  each nest in columns and sequences (inherited from seq_table) in rows. The
  order of the samples is derived from nest_table, with parents in the two
  leftmost columns. Each tab also lists the putative haplotypes inferred by the
  HpltFind() function and provides lists of unresolved sequences in haplotypes,
  sequences with unidentified decent (i.e., present in parents but not in
  offspring), sequences not assigned to haplotypes, and sequences with
  unidentified origin (i.e., present in offspring but not in parents).
  Note: NestTablesXL() will overwrite any existing file with the output file
  name in path_out.
}
\description{
\code{\link{NestTablesXL}} reads the R lists output by the HpltFind() function
and translates them to an Excel workbook for more convenient evaluation of the
inferred haplotypes and curation of unresolved and incongruent sequences. The
workbook contains separate tabs for each nest in the data set and provides an
overview of the genotypes of the samples in each nest and the inferred
haplotypes.
}
\details{
If you publish data or results produced with MHCtools, please cite both of
the following references:
Roved, J. (2022). MHCtools: Analysis of MHC data in non-model species. Cran.
Roved, J. (2024). MHCtools 1.5: Analysis of MHC sequencing data in R. In S.
Boegel (Ed.), HLA Typing: Methods and Protocols (2nd ed., pp. 275–295).
Humana Press. https://doi.org/10.1007/978-1-0716-3874-3_18
}
\examples{
nest_table <- nest_table
seq_table <- sequence_table_hplt
filepath <- system.file("extdata/HpltFindOut/", package="MHCtools")
path_out <- tempdir()
NestTablesXL(nest_table, seq_table, filepath, path_out)
}
\seealso{
\code{\link{HpltFind}}; for more information about 'dada2' visit
  <https://benjjneb.github.io/dada2/>
}
