% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLEce.R
\name{gof}
\alias{gof}
\alias{print.gof}
\title{Goodness-of-fit test for the efficient closed-form estimators}
\usage{
gof(x, digits = max(3, getOption("digits") - 3), ...)

\method{print}{gof}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{x}{an object of class "MLEce" made by the function \code{MLEce}.}

\item{digits}{a numeric number of significant digits.}

\item{...}{additional arguments affecting the goodness-of-fit test.}
}
\description{
Goodness-of-fit test for the efficient closed-form estimators
}
\details{
Generalized Cramer-von Mises test (chiu and Liu, 2009) is applied to do the goodness-of-fit test for multivariate distributions. For the bivariate gamma and Dirichlet distributions, the L2-symmetric discrepancy (SD2) statistics are applied. But the L2-centred discrepancy (CD2) statistics are applied in the bivariate Weibull distribution.
}
\examples{
data_BiGam <-  rBiGam(100, c(1,4,5))
res_BiGam  <- MLEce(data_BiGam, "BiGam")
gof(res_BiGam)
datt = rBiWei(n=50, c(4,3,3,4,0.6))
est_BiWei <-MLEce(datt, "BiWei")
gof(est_BiWei)
data_Diri <- LaplacesDemon::rdirichlet(n=60, c(3,1,2,4))
est_Diri <- MLEce(data_Diri, "Dirichlet")
gof(est_Diri)
}
\references{
chiu, S. N. and Liu, K. I. (2009) Generalized Cramer-Von Mises goodness-of-fit tests for multivariate distributions. \emph{Computational Statistics and Data Analysis}, 53, 3817-3834.
}
