% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CSR_plot.R
\name{CSR_plot}
\alias{CSR_plot}
\title{Create a Ternary Plot for CSR Plant Ecological Strategies}
\usage{
CSR_plot(
  data,
  point_size = 3,
  point_shape = 21,
  custom_colors = c(C = "#E60D0D", `C/CR` = "#BA0D3B", `C/CS` = "#BA3B0D", CR =
    "#7A0D7A", `C/CSR` = "#8A3B3B", CS = "#7A7A0D", `CR/CSR` = "#6B2B6B", `CS/CSR` =
    "#6B6B2B", `R/CR` = "#3B0DBA", CSR = "#545454", `S/CS` = "#3BBA0D", `R/CSR` =
    "#3B3B8A", `S/CSR` = "#3B8A3B", R = "#0D0DE6", `SR/CSR` = "#2B6B6B", S = "#0DE60D",
    `R/SR` = "#0D3BBA", `S/SR` = "#0DBA3B", SR = "#0D7A7A")
)
}
\arguments{
\item{data}{A data frame containing CSR strategy data. Must include columns:
\describe{
\item{C}{Numeric vector of Competitor strategy values (0-100)}
\item{S}{Numeric vector of Stress-tolerator strategy values (0-100)}
\item{R}{Numeric vector of Ruderal strategy values (0-100)}
\item{type}{Character vector indicating the CSR strategy type/classification}
}}

\item{point_size}{Numeric value specifying the size of points in the plot.
Default is 3.}

\item{point_shape}{Numeric value specifying the shape of points in the plot.
Default is 21 (filled circle with border).}

\item{custom_colors}{Named character vector specifying custom colors for each
CSR strategy type. Default includes 19 predefined colors for all possible
CSR combinations.}
}
\value{
A ggplot object representing a ternary plot with:
\itemize{
\item Points colored by CSR strategy type
\item Ternary coordinate system with C, S, R axes
\item Legend showing strategy types and their colors
\item Grid lines and arrows for better visualization
}
}
\description{
This function creates a ternary plot to visualize plant ecological strategies
based on the CSR (Competitor-Stress tolerator-Ruderal) framework developed by
Grime (1974). The plot is built using \code{ggplot2} and displays the relative
proportions of C, S, and R strategies for each species or sample.
}
\details{
The CSR strategy framework classifies plants into three primary functional
types based on their ecological strategies:
\describe{
\item{C (Competitors)}{Species adapted to productive, low-stress environments}
\item{S (Stress-tolerators)}{Species adapted to unproductive, high-stress environments}
\item{R (Ruderals)}{Species adapted to productive, high-disturbance environments}
}

The ternary plot allows visualization of the relative contribution of each
strategy, where each point represents a species positioned according to its
C, S, and R values (which sum to 100\%).
}
\examples{
data(PFF)
head(PFF)
traits <- data.frame(LA=PFF$Leaf_area, LDMC=PFF$LDMC, SLA=PFF$SLA)
head(traits)
result <- CSR(data = traits)
head(result)
CSR_plot(data=result)

}
\references{
\enumerate{
\item Grime, J.P. (1974). Vegetation classification by reference to strategies. Nature, 250, 26–31.
\item Hodgson, J.G., Wilson, P.J., Hunt, R., Grime, J.P. & Thompson, K. (1999).
Allocating CSR plant functional types: a soft approach to a hard problem. Oikos, 85, 282–294.
\item Caccianiga, M., Luzzaro, A., Pierce, S., Ceriani, R.M. & Cerabolini, B. (2006).
The functional basis of a primary succession resolved by CSR classification. Oikos, 112, 10–20.
\item Pierce, S., Negreiros, D., Cerabolini, B.E.L., Kattge, J., Díaz, S., et al. (2017).
A global method for calculating plant CSR ecological strategies applied across biomes world-wide.
Functional Ecology, 31: 444-457.
}
}
\seealso{
\code{\link{CSR}} or \code{\link{CSR_hodgson}} for calculating CSR strategies from plant functional traits
}
