% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATS.R
\name{ATS}
\alias{ATS}
\title{Akritas-Theil-Sen line for censored data}
\usage{
ATS(
  y.var,
  y.cen,
  x.var,
  x.cen = rep(0, length(x.var)),
  LOG = TRUE,
  retrans = FALSE,
  xlabel = NULL,
  ylabel = NULL,
  printstat = TRUE,
  drawplot = TRUE
)
}
\arguments{
\item{y.var}{The column of y (response variable) values plus detection limits}

\item{y.cen}{The y-variable indicators, where 1 (or \code{TRUE}) indicates a detection limit in the \code{y.var} column, and \code{0} (or \code{FALSE}) indicates a detected value in \code{y.var}.}

\item{x.var}{The column of x (explanatory variable) values plus detection limits}

\item{x.cen}{The x-variable indicators, where 1 (or \code{TRUE}) indicates a detection limit in the \code{x.var} column, and \code{0} (or \code{FALSE}) indicates a detected value in \code{x.var}.}

\item{LOG}{Indicator of whether to compute the ATS line in the original y units, or for their logarithms.  The default is to use the logarithms (\code{LOG = TRUE}).  To compute in original units, specify the option \code{LOG = FALSE} (or \code{LOG = 0}).}

\item{retrans}{Indicator of whether to retransform the plot and line back to original Y-variable units.  Not needed when \code{LOG = FALSE}. When \code{retrans = FALSE} & \code{LOG = TRUE} the plot is drawn with logY units (default). When \code{retrans =  TRUE} & \code{LOG = TRUE} the plot is drawn with original Y units.}

\item{xlabel}{Custom label for the x axis of plots.  Default is x variable column name.}

\item{ylabel}{Custom label for the y axis of plots.  Default is y variable column name.}

\item{printstat}{Logical \code{TRUE}/\code{FALSE} option of whether to print the resulting statistics in the console window, or not.  Default is \code{TRUE.}}

\item{drawplot}{Logical \code{TRUE}/\code{FALSE} option of whether to draw plots or not. Default is \code{TRUE}}
}
\value{
Coefficients (intercept and slope) for the ATS line are printed, along with Kendall's tau correlation coefficient, test statistic S, and the (single) p-value for the test that tau and slope both equal zero. A scatterplot with the fitted trend-line superimposed is also drawn.
}
\description{
Computes Kendall's tau and the Akritas-Theil-Sen (ATS) line for censored data, along with the test that the slope (and Kendall's tau) equal zero.  For one x variable regression.
}
\examples{
\dontrun{
# Both y and x are censored
data(PbHeron)
with(PbHeron, ATS(Blood, BloodCen, Kidney, KidneyCen))

# x is not censored
data(Brumbaugh)
with(Brumbaugh,ATS(Hg, HgCen, PctWetland))
}
}
\references{
Akritas, M.G., Murphy, S.A., LaValley, M.P., 1995. The Theil-Sen Estimator With Doubly Censored Data and Applications to Astronomy. Journal of the American Statistical Association 90, 170–177. https://doi.org/10.2307/2291140

Helsel, D.R., 2011. Statistics for Censored Environmental Data using Minitab and R, 2nd ed. John Wiley & Sons, USA, N.J.
}
\keyword{censored}
\keyword{trend}
