% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NAP_posterior.R
\name{NAP_posterior}
\alias{NAP_posterior}
\title{Conduct posterior inference with NAP-based priors}
\usage{
NAP_posterior(
  NAP_prior = NULL,
  y_EC2,
  s_EC2,
  iter = 2000,
  chains = 4,
  model = NULL
)
}
\arguments{
\item{NAP_prior}{An object returned by \code{\link{NAP_prior}()} containing the full
the NAP prior (and if eNAP without assumed direct effects, calibrated tuning parameters (a,b))}

\item{y_EC2}{Numeric scalar. Direct estimate \eqn{y_{EC2}} (e.g., log-HR) for
\eqn{E} vs \eqn{C2}.}

\item{s_EC2}{Positive numeric scalar. Sampling variance \eqn{s^2_{EC2}} for \eqn{y_{EC2}}.}

\item{iter}{Total MCMC iterations per chain (default \code{2000}).}

\item{chains}{Number of MCMC chains (default \code{4}).}

\item{model}{Either a length-1 character string containing JAGS model code or
a path to a JAGS model file. If \code{NULL}, a package default will be used.}
}
\value{
A list of class \code{"NAP_posterior_result"} with elements:
\itemize{
\item \code{posterior_sum}: data frame with posterior summaries for \eqn{\theta_{E,C2}}
(mean, sd, 95\\% interval, \code{prob_E_better}), and the prior/posterior
weights (\code{prior_weight}, \code{post_weight}).
\item \code{enap_prior}: For eNAP only: data frame describing the eNAP prior with calculated data-dependent weight:
columns for \code{NAP (Informative)} and \code{Vague}, rows for
\code{Mixing Weight}, \code{Mean}, \code{Variance}, and
\code{ESS (events)} if available.
\item \code{jags_fit}: the \code{R2jags} fit object.
}#'
}
\description{
Draw posterior via MCMC (JAGS) with derived NAP priors from NAP_prior function
both setting (one external trial/multiple external trials) and NAP method (NAP/mNAP/eNAP)
will be determined by the provided NAP_prior object. If using eNAP, make sure the
tuning parameter used to derive NAP_prior are calibrated by tune_param_eNAP function.
}
\examples{
\donttest{
# Create a NAP_prior object
my_naprior <- NAP_prior(
  weight_mtd = "fixed", w = 0.50,       # fixed mixture weight
  y_EC1  = -0.36, s_EC1  = 0.16^2,
  y_C2C1 = -0.30, s_C2C1 = 0.14^2,      # single external trial
  tau0   = 1000
)

# Calculate posterior
out <- NAP_posterior(
  NAP_prior = my_naprior,
  y_EC2 = -0.20, s_EC2 = 0.18^2,
  iter = 1000, chains = 2
)
out$posterior_sum
out$enap_prior
}

}
