% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMtransInp.R
\name{NMtransInp}
\alias{NMtransInp}
\title{translate the column names according to the $INPUT section of a control stream}
\usage{
NMtransInp(
  data,
  file,
  lines,
  translate = TRUE,
  recover.cols = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{data}{the data to translate}

\item{file}{the list file or control stream}

\item{translate}{Do translation according to Nonmem code or not
(default `TRUE`)? If not, an overview of column names in data
and in Nonmem code is still returned with the data.}

\item{recover.cols}{recover columns that were not used in the
NONMEM control stream? Default is TRUE. Can only be negative
when translate=FALSE.}

\item{quiet}{Suppress warnings about data columns?}
}
\value{
data with column names translated as specified by nonmem
    control stream. Class same as for 'data' argument. Class
    data.table.
}
\description{
translate the column names according to the $INPUT section of a control stream
}
\details{
If `translate=FALSE`, data is returned with column names
    as in data file (not informed by the control stream `$INPUT`
    section). If `translate=TRUE`, `NMtransInp` renames and copies
    columns as specified in `$INPUT`. This means that
}
\keyword{internal}
